/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.network.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import org.activemq.network.jms.DestinationBridge;
import org.activemq.network.jms.JmsQueueConnector;

class QueueBridge
extends DestinationBridge {
    protected Queue consumerQueue;
    protected Queue producerQueue;
    protected QueueSession consumerSession;
    protected QueueSession producerSession;
    protected String selector;
    protected QueueSender producer;
    protected QueueConnection consumerConnection;
    protected QueueConnection producerConnection;
    protected JmsQueueConnector jmsQueueConnector;

    QueueBridge() {
    }

    public void stop() throws Exception {
        super.stop();
        if (this.consumerSession != null) {
            this.consumerSession.close();
        }
        if (this.producerSession != null) {
            this.producerSession.close();
        }
    }

    protected void setJmsQueueConnector(JmsQueueConnector connector) {
        this.jmsQueueConnector = connector;
    }

    protected MessageConsumer createConsumer() throws JMSException {
        this.consumerSession = this.consumerConnection.createQueueSession(false, 2);
        this.producerSession = this.producerConnection.createQueueSession(false, 1);
        QueueReceiver consumer = null;
        consumer = this.selector != null && this.selector.length() > 0 ? this.consumerSession.createReceiver(this.consumerQueue, this.selector) : this.consumerSession.createReceiver(this.consumerQueue);
        return consumer;
    }

    protected MessageProducer createProducer() throws JMSException {
        this.producer = this.producerSession.createSender(null);
        return this.producer;
    }

    protected Destination processReplyToDestination(Destination destination) {
        Queue queue = (Queue)destination;
        return this.jmsQueueConnector.createReplyToQueueBridge(queue, this.getConsumerConnection(), this.getProducerConnection());
    }

    protected void sendMessage(Message message) throws JMSException {
        this.producer.send(this.producerQueue, message);
    }

    public QueueConnection getConsumerConnection() {
        return this.consumerConnection;
    }

    public void setConsumerConnection(QueueConnection consumerConnection) {
        this.consumerConnection = consumerConnection;
    }

    public Queue getConsumerQueue() {
        return this.consumerQueue;
    }

    public void setConsumerQueue(Queue consumerQueue) {
        this.consumerQueue = consumerQueue;
    }

    public QueueConnection getProducerConnection() {
        return this.producerConnection;
    }

    public void setProducerConnection(QueueConnection producerConnection) {
        this.producerConnection = producerConnection;
    }

    public Queue getProducerQueue() {
        return this.producerQueue;
    }

    public void setProducerQueue(Queue producerQueue) {
        this.producerQueue = producerQueue;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }
}

