/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.network;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.io.IOException;
import org.activemq.command.ActiveMQTopic;
import org.activemq.command.BrokerId;
import org.activemq.command.BrokerInfo;
import org.activemq.command.Command;
import org.activemq.command.ConnectionId;
import org.activemq.command.ConnectionInfo;
import org.activemq.command.ConsumerId;
import org.activemq.command.ConsumerInfo;
import org.activemq.command.DataStructure;
import org.activemq.command.Message;
import org.activemq.command.MessageAck;
import org.activemq.command.MessageDispatch;
import org.activemq.command.ProducerInfo;
import org.activemq.command.RemoveInfo;
import org.activemq.command.SessionInfo;
import org.activemq.command.ShutdownInfo;
import org.activemq.network.Bridge;
import org.activemq.transport.Transport;
import org.activemq.transport.TransportListener;
import org.activemq.util.IdGenerator;
import org.activemq.util.LongSequenceGenerator;
import org.activemq.util.ServiceStopper;
import org.activemq.util.ServiceSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DemandForwardingBridge
implements Bridge {
    private static final Log log = LogFactory.getLog((Class)DemandForwardingBridge.class);
    private final Transport localBroker;
    private final Transport remoteBroker;
    IdGenerator idGenerator = new IdGenerator();
    LongSequenceGenerator consumerIdGenerator = new LongSequenceGenerator();
    ConnectionInfo connectionInfo;
    SessionInfo sessionInfo;
    ProducerInfo producerInfo;
    private String clientId;
    private int prefetchSize = 1000;
    private boolean dispatchAsync;
    private String destinationFilter = ">";
    private ConsumerInfo demandConsumerInfo;
    private int demandConsumerDispatched;
    BrokerId localBrokerId;
    BrokerId remoteBrokerId;
    ConcurrentHashMap subscriptionMapByLocalId = new ConcurrentHashMap();
    ConcurrentHashMap subscriptionMapByRemoteId = new ConcurrentHashMap();
    protected final BrokerId[] localBrokerPath = new BrokerId[]{null};
    protected final BrokerId[] remoteBrokerPath = new BrokerId[]{null};

    public DemandForwardingBridge(Transport localBroker, Transport remoteBroker) {
        this.localBroker = localBroker;
        this.remoteBroker = remoteBroker;
    }

    public void start() throws Exception {
        log.info((Object)("Starting a network connection between " + this.localBroker + " and " + this.remoteBroker + " has been established."));
        this.localBroker.setTransportListener(new TransportListener(){

            public void onCommand(Command command) {
                DemandForwardingBridge.this.serviceLocalCommand(command);
            }

            public void onException(IOException error) {
                DemandForwardingBridge.this.serviceLocalException(error);
            }
        });
        this.remoteBroker.setTransportListener(new TransportListener(){

            public void onCommand(Command command) {
                DemandForwardingBridge.this.serviceRemoteCommand(command);
            }

            public void onException(IOException error) {
                DemandForwardingBridge.this.serviceRemoteException(error);
            }
        });
        this.localBroker.start();
        this.remoteBroker.start();
    }

    protected void triggerStartBridge() throws IOException {
        Thread thead = new Thread(){

            public void run() {
                try {
                    DemandForwardingBridge.this.startBridge();
                }
                catch (IOException e) {
                    log.error((Object)("Failed to start network bridge: " + e), (Throwable)e);
                }
            }
        };
        thead.start();
    }

    protected void startBridge() throws IOException {
        BrokerInfo brokerInfo = new BrokerInfo();
        this.remoteBroker.oneway(brokerInfo);
        this.connectionInfo = new ConnectionInfo();
        this.connectionInfo.setConnectionId(new ConnectionId(this.idGenerator.generateId()));
        this.connectionInfo.setClientId(this.clientId);
        this.localBroker.oneway(this.connectionInfo);
        this.remoteBroker.oneway(this.connectionInfo);
        this.sessionInfo = new SessionInfo(this.connectionInfo, 1L);
        this.localBroker.oneway(this.sessionInfo);
        this.remoteBroker.oneway(this.sessionInfo);
        this.producerInfo = new ProducerInfo(this.sessionInfo, 1L);
        this.producerInfo.setResponseRequired(false);
        this.remoteBroker.oneway(this.producerInfo);
        this.demandConsumerInfo = new ConsumerInfo(this.sessionInfo, 1L);
        this.demandConsumerInfo.setDispatchAsync(this.dispatchAsync);
        this.demandConsumerInfo.setDestination(new ActiveMQTopic("ActiveMQ.Advisory.Consumer." + this.destinationFilter));
        this.demandConsumerInfo.setPrefetchSize(this.prefetchSize);
        this.remoteBroker.oneway(this.demandConsumerInfo);
        log.info((Object)("Network connection between " + this.localBroker + " and " + this.remoteBroker + " has been established."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        try {
            if (this.connectionInfo != null) {
                this.localBroker.request(this.connectionInfo.createRemoveCommand());
                this.remoteBroker.request(this.connectionInfo.createRemoveCommand());
            }
            this.localBroker.setTransportListener(null);
            this.remoteBroker.setTransportListener(null);
            this.remoteBroker.oneway(new ShutdownInfo());
            this.localBroker.oneway(new ShutdownInfo());
        }
        catch (IOException e) {
            log.debug((Object)"Caught exception stopping", (Throwable)e);
        }
        finally {
            ServiceStopper ss = new ServiceStopper();
            ss.stop(this.localBroker);
            ss.stop(this.remoteBroker);
            ss.throwFirstException();
        }
    }

    protected void serviceRemoteException(IOException error) {
        log.info((Object)("Network connection between " + this.localBroker + " and " + this.remoteBroker + " shutdown: " + error.getMessage()), (Throwable)error);
        ServiceSupport.dispose(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceRemoteCommand(Command command) {
        block11: {
            try {
                if (command.isMessageDispatch()) {
                    MessageDispatch md = (MessageDispatch)command;
                    this.serviceRemoteConsumerAdvisory(md.getMessage().getDataStructure());
                    ++this.demandConsumerDispatched;
                    if ((double)this.demandConsumerDispatched > (double)this.demandConsumerInfo.getPrefetchSize() * 0.75) {
                        this.remoteBroker.oneway(new MessageAck(md, 2, this.demandConsumerDispatched));
                        this.demandConsumerDispatched = 0;
                    }
                    break block11;
                }
                if (command.isBrokerInfo()) {
                    DemandForwardingBridge md = this;
                    synchronized (md) {
                        this.remoteBrokerPath[0] = this.remoteBrokerId = ((BrokerInfo)command).getBrokerId();
                        if (this.localBrokerId != null) {
                            if (this.localBrokerId.equals(this.remoteBrokerId)) {
                                log.info((Object)"Disconnecting loop back connection.");
                                ServiceSupport.dispose(this);
                            } else {
                                this.triggerStartBridge();
                            }
                        }
                        break block11;
                    }
                }
                log.warn((Object)("Unexpected remote command: " + command));
            }
            catch (IOException e) {
                this.serviceRemoteException(e);
            }
        }
    }

    private void serviceRemoteConsumerAdvisory(DataStructure data) throws IOException {
        ConsumerId id;
        DemandSubscription sub;
        if (data.getClass() == ConsumerInfo.class) {
            ConsumerInfo info = (ConsumerInfo)data;
            BrokerId[] path = info.getBrokerPath();
            String pathStr = "{";
            for (int i = 0; path != null && i < path.length; ++i) {
                pathStr = pathStr + path[i] + " , ";
            }
            pathStr = pathStr + "}";
            if (this.contains(info.getBrokerPath(), this.localBrokerPath[0])) {
                return;
            }
            info.setBrokerPath(this.appendToBrokerPath(info.getBrokerPath(), this.remoteBrokerPath));
            DemandSubscription sub2 = new DemandSubscription(info);
            sub2.localInfo.setConsumerId(new ConsumerId(this.sessionInfo.getSessionId(), this.consumerIdGenerator.getNextSequenceId()));
            sub2.localInfo.setDispatchAsync(this.dispatchAsync);
            sub2.localInfo.setPrefetchSize(this.prefetchSize);
            byte priority = -5;
            if (priority > -128 && info.getBrokerPath() != null && info.getBrokerPath().length > 1) {
                priority = (byte)(priority - (info.getBrokerPath().length + 1));
            }
            sub2.localInfo.setPriority(priority);
            this.subscriptionMapByLocalId.put((Object)sub2.localInfo.getConsumerId(), (Object)sub2);
            this.subscriptionMapByRemoteId.put((Object)sub2.remoteInfo.getConsumerId(), (Object)sub2);
            sub2.localInfo.setBrokerPath(info.getBrokerPath());
            sub2.localInfo.setNetworkSubscription(true);
            this.localBroker.oneway(sub2.localInfo);
        }
        if (data.getClass() == RemoveInfo.class && (sub = (DemandSubscription)this.subscriptionMapByRemoteId.remove((Object)(id = (ConsumerId)((RemoveInfo)data).getObjectId()))) != null) {
            this.subscriptionMapByLocalId.remove((Object)sub.localInfo.getConsumerId());
            this.localBroker.oneway(sub.localInfo.createRemoveCommand());
        }
    }

    protected void serviceLocalException(IOException error) {
        log.info((Object)("Network connection between " + this.localBroker + " and " + this.remoteBroker + " shutdown: " + error.getMessage()), (Throwable)error);
        ServiceSupport.dispose(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceLocalCommand(Command command) {
        block16: {
            try {
                if (command.isMessageDispatch()) {
                    ConsumerInfo info;
                    MessageDispatch md = (MessageDispatch)command;
                    Message message = md.getMessage();
                    if (message.isRecievedByDFBridge()) {
                        return;
                    }
                    if (message.isAdvisory() && message.getDataStructure() != null && message.getDataStructure().getDataStructureType() == 5 && (info = (ConsumerInfo)message.getDataStructure()).isNetworkSubscription()) {
                        return;
                    }
                    DemandSubscription sub = (DemandSubscription)this.subscriptionMapByLocalId.get((Object)md.getConsumerId());
                    if (sub != null) {
                        if (this.contains(message.getBrokerPath(), this.remoteBrokerPath[0])) {
                            return;
                        }
                        message.setBrokerPath(this.appendToBrokerPath(message.getBrokerPath(), this.localBrokerPath));
                        message.setProducerId(this.producerInfo.getProducerId());
                        message.setDestination(md.getDestination());
                        if (message.getOriginalTransactionId() == null) {
                            message.setOriginalTransactionId(message.getTransactionId());
                        }
                        message.setTransactionId(null);
                        message.evictMarshlledForm();
                        this.remoteBroker.oneway(message);
                        ++sub.dispatched;
                        if ((double)sub.dispatched > (double)sub.localInfo.getPrefetchSize() * 0.75) {
                            this.localBroker.oneway(new MessageAck(md, 2, this.demandConsumerDispatched));
                            sub.dispatched = 0;
                        }
                    }
                    break block16;
                }
                if (command.isBrokerInfo()) {
                    DemandForwardingBridge md = this;
                    synchronized (md) {
                        this.localBrokerPath[0] = this.localBrokerId = ((BrokerInfo)command).getBrokerId();
                        if (this.remoteBrokerId != null) {
                            if (this.remoteBrokerId.equals(this.localBrokerId)) {
                                log.info((Object)"Disconnecting loop back connection.");
                                ServiceSupport.dispose(this);
                            } else {
                                this.triggerStartBridge();
                            }
                        }
                        break block16;
                    }
                }
                log.warn((Object)("Unexpected local command: " + command));
            }
            catch (IOException e) {
                this.serviceLocalException(e);
            }
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public int getPrefetchSize() {
        return this.prefetchSize;
    }

    public void setPrefetchSize(int prefetchSize) {
        this.prefetchSize = prefetchSize;
    }

    public boolean isDispatchAsync() {
        return this.dispatchAsync;
    }

    public void setDispatchAsync(boolean dispatchAsync) {
        this.dispatchAsync = dispatchAsync;
    }

    public String getDestinationFilter() {
        return this.destinationFilter;
    }

    public void setDestinationFilter(String destinationFilter) {
        this.destinationFilter = destinationFilter;
    }

    private boolean contains(BrokerId[] brokerPath, BrokerId brokerId) {
        if (brokerPath != null) {
            for (int i = 0; i < brokerPath.length; ++i) {
                if (!brokerId.equals(brokerPath[i])) continue;
                return true;
            }
        }
        return false;
    }

    private BrokerId[] appendToBrokerPath(BrokerId[] brokerPath, BrokerId[] pathsToAppend) {
        if (brokerPath == null || brokerPath.length == 0) {
            return pathsToAppend;
        }
        BrokerId[] rc = new BrokerId[brokerPath.length + pathsToAppend.length];
        System.arraycopy(brokerPath, 0, rc, 0, brokerPath.length);
        System.arraycopy(pathsToAppend, 0, rc, brokerPath.length, pathsToAppend.length);
        return rc;
    }

    private static class DemandSubscription {
        ConsumerInfo remoteInfo;
        ConsumerInfo localInfo;
        int dispatched;

        public DemandSubscription(ConsumerInfo info) {
            this.remoteInfo = info;
            this.localInfo = info.copy();
        }
    }
}

