/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.memory.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activemq.broker.region.MessageReference;
import org.activemq.broker.region.Subscription;
import org.activemq.command.ActiveMQDestination;
import org.activemq.command.ActiveMQMessage;
import org.activemq.filter.DestinationMap;
import org.activemq.memory.buffer.MessageBuffer;
import org.activemq.memory.buffer.MessageQueue;
import org.activemq.memory.buffer.OrderBasedMessageBuffer;
import org.activemq.memory.list.MessageList;

public class DestinationBasedMessageList
implements MessageList {
    private MessageBuffer messageBuffer;
    private Map queueIndex = new HashMap();
    private DestinationMap subscriptionIndex = new DestinationMap();
    private Object lock = new Object();

    public DestinationBasedMessageList(int maximumSize) {
        this(new OrderBasedMessageBuffer(maximumSize));
    }

    public DestinationBasedMessageList(MessageBuffer buffer) {
        this.messageBuffer = buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(MessageReference node) {
        ActiveMQMessage message = (ActiveMQMessage)node.getMessageHardRef();
        ActiveMQDestination destination = message.getDestination();
        MessageQueue queue = null;
        Object object = this.lock;
        synchronized (object) {
            queue = (MessageQueue)this.queueIndex.get(destination);
            if (queue == null) {
                queue = this.messageBuffer.createMessageQueue();
                this.queueIndex.put(destination, queue);
                this.subscriptionIndex.put(destination, queue);
            }
        }
        queue.add(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMessages(Subscription sub) {
        Set set = null;
        Object object = this.lock;
        synchronized (object) {
            set = this.subscriptionIndex.get(sub.getConsumerInfo().getDestination());
        }
        ArrayList answer = new ArrayList();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            MessageQueue queue = (MessageQueue)iter.next();
            queue.appendMessages(answer);
        }
        return answer;
    }

    public void clear() {
        this.messageBuffer.clear();
    }
}

