/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker.region.policy;

import java.util.Iterator;
import java.util.List;
import org.activemq.broker.ConnectionContext;
import org.activemq.broker.region.MessageReference;
import org.activemq.broker.region.Subscription;
import org.activemq.broker.region.policy.SubscriptionRecoveryPolicy;
import org.activemq.filter.MessageEvaluationContext;
import org.activemq.memory.list.DestinationBasedMessageList;
import org.activemq.memory.list.MessageList;
import org.activemq.memory.list.SimpleMessageList;

public class FixedSizedSubscriptionRecoveryPolicy
implements SubscriptionRecoveryPolicy {
    private MessageList buffer;
    private int maximumSize = 0x640000;
    private boolean useSharedBuffer = true;

    public void add(ConnectionContext context, MessageReference message) throws Throwable {
        this.buffer.add(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover(ConnectionContext context, Subscription sub) throws Throwable {
        List copy = this.buffer.getMessages(sub);
        if (!copy.isEmpty()) {
            MessageEvaluationContext msgContext = context.getMessageEvaluationContext();
            try {
                Iterator iter = copy.iterator();
                while (iter.hasNext()) {
                    MessageReference node = (MessageReference)iter.next();
                    msgContext.setDestination(node.getRegionDestination().getActiveMQDestination());
                    msgContext.setMessageReference(node);
                    if (!sub.matches(node, msgContext)) continue;
                    sub.add(node);
                }
            }
            finally {
                msgContext.clear();
            }
        }
    }

    public void start() throws Exception {
        this.buffer = this.createMessageList();
    }

    public void stop() throws Exception {
        this.buffer.clear();
    }

    public MessageList getBuffer() {
        return this.buffer;
    }

    public void setBuffer(MessageList buffer) {
        this.buffer = buffer;
    }

    public int getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(int maximumSize) {
        this.maximumSize = maximumSize;
    }

    public boolean isUseSharedBuffer() {
        return this.useSharedBuffer;
    }

    public void setUseSharedBuffer(boolean useSharedBuffer) {
        this.useSharedBuffer = useSharedBuffer;
    }

    protected MessageList createMessageList() {
        if (this.useSharedBuffer) {
            return new SimpleMessageList(this.maximumSize);
        }
        return new DestinationBasedMessageList(this.maximumSize);
    }
}

