/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker.region;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.Iterator;
import java.util.Set;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import org.activemq.broker.ConnectionContext;
import org.activemq.broker.region.AbstractRegion;
import org.activemq.broker.region.Destination;
import org.activemq.broker.region.DestinationStatistics;
import org.activemq.broker.region.DurableTopicSubscription;
import org.activemq.broker.region.Subscription;
import org.activemq.broker.region.Topic;
import org.activemq.broker.region.TopicSubscription;
import org.activemq.broker.region.policy.PolicyEntry;
import org.activemq.broker.region.policy.PolicyMap;
import org.activemq.command.ActiveMQDestination;
import org.activemq.command.ActiveMQTopic;
import org.activemq.command.ConsumerInfo;
import org.activemq.command.RemoveSubscriptionInfo;
import org.activemq.memory.UsageManager;
import org.activemq.store.PersistenceAdapter;
import org.activemq.store.TopicMessageStore;
import org.activemq.thread.TaskRunnerFactory;
import org.activemq.util.SubscriptionKey;

public class TopicRegion
extends AbstractRegion {
    protected final ConcurrentHashMap durableSubscriptions = new ConcurrentHashMap();
    private final PolicyMap policyMap;

    public TopicRegion(DestinationStatistics destinationStatistics, UsageManager memoryManager, TaskRunnerFactory taskRunnerFactory, PersistenceAdapter persistenceAdapter, PolicyMap policyMap) {
        super(destinationStatistics, memoryManager, taskRunnerFactory, persistenceAdapter);
        this.policyMap = policyMap;
    }

    public void addConsumer(ConnectionContext context, ConsumerInfo info) throws Throwable {
        if (info.isDurable()) {
            SubscriptionKey key = new SubscriptionKey(context.getClientId(), info.getSubcriptionName());
            DurableTopicSubscription sub = (DurableTopicSubscription)this.durableSubscriptions.get((Object)key);
            if (sub != null) {
                if (sub.isActive()) {
                    throw new JMSException("Durable consumer is in use");
                }
                if (this.hasDurableSubChanged(info, sub.getConsumerInfo())) {
                    this.durableSubscriptions.remove((Object)key);
                    Iterator iter = this.destinations.values().iterator();
                    while (iter.hasNext()) {
                        Topic topic = (Topic)iter.next();
                        topic.deleteSubscription(context, key);
                    }
                    super.removeConsumer(context, sub.getConsumerInfo());
                    super.addConsumer(context, info);
                } else {
                    this.subscriptions.remove((Object)sub.getConsumerInfo().getConsumerId());
                    this.subscriptions.put((Object)info.getConsumerId(), (Object)sub);
                    sub.activate(context, info);
                }
            } else {
                super.addConsumer(context, info);
            }
        } else {
            super.addConsumer(context, info);
        }
    }

    public void removeConsumer(ConnectionContext context, ConsumerInfo info) throws Throwable {
        if (info.isDurable()) {
            SubscriptionKey key = new SubscriptionKey(context.getClientId(), info.getSubcriptionName());
            DurableTopicSubscription sub = (DurableTopicSubscription)this.durableSubscriptions.get((Object)key);
            if (sub != null) {
                sub.deactivate();
            }
        } else {
            super.removeConsumer(context, info);
        }
    }

    public void removeSubscription(ConnectionContext context, RemoveSubscriptionInfo info) throws Throwable {
        SubscriptionKey key = new SubscriptionKey(info.getClientId(), info.getSubcriptionName());
        DurableTopicSubscription sub = (DurableTopicSubscription)this.durableSubscriptions.get((Object)key);
        if (sub == null) {
            throw new InvalidDestinationException("No durable subscription exists for: " + info.getSubcriptionName());
        }
        if (sub.isActive()) {
            throw new JMSException("Durable consumer is in use");
        }
        this.durableSubscriptions.remove((Object)key);
        Iterator iter = this.destinations.values().iterator();
        while (iter.hasNext()) {
            Topic topic = (Topic)iter.next();
            topic.deleteSubscription(context, key);
        }
        super.removeConsumer(context, sub.getConsumerInfo());
    }

    public String toString() {
        return "TopicRegion: destinations=" + this.destinations.size() + ", subscriptions=" + this.subscriptions.size() + ", memory=" + this.memoryManager.getPercentUsage() + "%";
    }

    protected Destination createDestination(ActiveMQDestination destination) throws Throwable {
        TopicMessageStore store = this.persistenceAdapter.createTopicMessageStore((ActiveMQTopic)destination);
        Topic topic = new Topic(destination, store, this.memoryManager, this.destinationStatistics, this.taskRunnerFactory);
        this.configureTopic(topic, destination);
        return topic;
    }

    protected void configureTopic(Topic topic, ActiveMQDestination destination) {
        PolicyEntry entry;
        if (this.policyMap != null && (entry = this.policyMap.getEntryFor(destination)) != null) {
            entry.configure(topic);
        }
    }

    protected Subscription createSubscription(ConnectionContext context, ConsumerInfo info) throws JMSException {
        if (info.isDurable()) {
            SubscriptionKey key = new SubscriptionKey(context.getClientId(), info.getSubcriptionName());
            DurableTopicSubscription sub = (DurableTopicSubscription)this.durableSubscriptions.get((Object)key);
            if (sub != null) {
                throw new JMSException("That durable subscription is already active.");
            }
            sub = new DurableTopicSubscription(context, info);
            this.durableSubscriptions.put((Object)key, (Object)sub);
            return sub;
        }
        return new TopicSubscription(context, info, this.memoryManager);
    }

    private boolean hasDurableSubChanged(ConsumerInfo info1, ConsumerInfo info2) {
        if (info1.getSelector() != null ^ info2.getSelector() != null) {
            return true;
        }
        if (info1.getSelector() != null && !info1.getSelector().equals(info2.getSelector())) {
            return true;
        }
        return !info1.getDestination().equals(info2.getDestination());
    }

    protected Set getInactiveDestinations() {
        Set inactiveDestinations = super.getInactiveDestinations();
        Iterator iter = inactiveDestinations.iterator();
        while (iter.hasNext()) {
            ActiveMQDestination dest = (ActiveMQDestination)iter.next();
            if (dest.isTopic()) continue;
            iter.remove();
        }
        return inactiveDestinations;
    }
}

