/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker.region;

import javax.jms.JMSException;
import org.activemq.broker.ConnectionContext;
import org.activemq.broker.region.AbstractRegion;
import org.activemq.broker.region.Destination;
import org.activemq.broker.region.DestinationStatistics;
import org.activemq.broker.region.Subscription;
import org.activemq.broker.region.Topic;
import org.activemq.broker.region.TopicSubscription;
import org.activemq.command.ActiveMQDestination;
import org.activemq.command.ActiveMQTempDestination;
import org.activemq.command.ConsumerInfo;
import org.activemq.memory.UsageManager;
import org.activemq.thread.TaskRunnerFactory;

public class TempTopicRegion
extends AbstractRegion {
    public TempTopicRegion(DestinationStatistics destinationStatistics, UsageManager memoryManager, TaskRunnerFactory taskRunnerFactory) {
        super(destinationStatistics, memoryManager, taskRunnerFactory, null);
        this.setAutoCreateDestinations(false);
    }

    protected Destination createDestination(ActiveMQDestination destination) throws Throwable {
        final ActiveMQTempDestination tempDest = (ActiveMQTempDestination)destination;
        return new Topic(destination, null, this.memoryManager, this.destinationStatistics, this.taskRunnerFactory){

            public void addSubscription(ConnectionContext context, Subscription sub) throws Throwable {
                if (!tempDest.getConnectionId().equals(sub.getConsumerInfo().getConsumerId().getConnectionId())) {
                    throw new JMSException("Cannot subscribe to remote temporary destination: " + tempDest);
                }
                super.addSubscription(context, sub);
            }
        };
    }

    protected Subscription createSubscription(ConnectionContext context, ConsumerInfo info) throws JMSException {
        if (info.isDurable()) {
            throw new JMSException("A durable subscription cannot be created for a temporary topic.");
        }
        return new TopicSubscription(context, info, this.memoryManager);
    }

    public String toString() {
        return "TempTopicRegion: destinations=" + this.destinations.size() + ", subscriptions=" + this.subscriptions.size() + ", memory=" + this.memoryManager.getPercentUsage() + "%";
    }
}

