/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker.region;

import java.util.Iterator;
import java.util.Set;
import javax.jms.InvalidSelectorException;
import org.activemq.broker.ConnectionContext;
import org.activemq.broker.region.AbstractRegion;
import org.activemq.broker.region.Destination;
import org.activemq.broker.region.DestinationStatistics;
import org.activemq.broker.region.Queue;
import org.activemq.broker.region.QueueBrowserSubscription;
import org.activemq.broker.region.QueueSubscription;
import org.activemq.broker.region.Subscription;
import org.activemq.broker.region.policy.PolicyEntry;
import org.activemq.broker.region.policy.PolicyMap;
import org.activemq.command.ActiveMQDestination;
import org.activemq.command.ActiveMQQueue;
import org.activemq.command.ConsumerInfo;
import org.activemq.memory.UsageManager;
import org.activemq.store.MessageStore;
import org.activemq.store.PersistenceAdapter;
import org.activemq.thread.TaskRunnerFactory;

public class QueueRegion
extends AbstractRegion {
    private final PolicyMap policyMap;

    public QueueRegion(DestinationStatistics destinationStatistics, UsageManager memoryManager, TaskRunnerFactory taskRunnerFactory, PersistenceAdapter persistenceAdapter, PolicyMap policyMap) {
        super(destinationStatistics, memoryManager, taskRunnerFactory, persistenceAdapter);
        this.policyMap = policyMap;
    }

    public String toString() {
        return "QueueRegion: destinations=" + this.destinations.size() + ", subscriptions=" + this.subscriptions.size() + ", memory=" + this.memoryManager.getPercentUsage() + "%";
    }

    protected Destination createDestination(ActiveMQDestination destination) throws Throwable {
        MessageStore store = this.persistenceAdapter.createQueueMessageStore((ActiveMQQueue)destination);
        Queue queue = new Queue(destination, this.memoryManager, store, this.destinationStatistics, this.taskRunnerFactory);
        this.configureQueue(queue, destination);
        return queue;
    }

    protected void configureQueue(Queue queue, ActiveMQDestination destination) {
        PolicyEntry entry;
        if (this.policyMap != null && (entry = this.policyMap.getEntryFor(destination)) != null) {
            entry.configure(queue);
        }
    }

    protected Subscription createSubscription(ConnectionContext context, ConsumerInfo info) throws InvalidSelectorException {
        if (info.isBrowser()) {
            return new QueueBrowserSubscription(context, info);
        }
        return new QueueSubscription(context, info);
    }

    protected Set getInactiveDestinations() {
        Set inactiveDestinations = super.getInactiveDestinations();
        Iterator iter = inactiveDestinations.iterator();
        while (iter.hasNext()) {
            ActiveMQDestination dest = (ActiveMQDestination)iter.next();
            if (dest.isQueue()) continue;
            iter.remove();
        }
        return inactiveDestinations;
    }
}

