/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker.region;

import javax.jms.InvalidSelectorException;
import org.activemq.broker.ConnectionContext;
import org.activemq.broker.region.IndirectMessageReference;
import org.activemq.broker.region.MessageReference;
import org.activemq.broker.region.PrefetchSubscription;
import org.activemq.command.ConsumerInfo;
import org.activemq.command.Message;
import org.activemq.command.MessageDispatch;
import org.activemq.filter.MessageEvaluationContext;

public class QueueBrowserSubscription
extends PrefetchSubscription {
    boolean browseDone;

    public QueueBrowserSubscription(ConnectionContext context, ConsumerInfo info) throws InvalidSelectorException {
        super(context, info);
    }

    protected boolean canDispatch(MessageReference node) {
        return !((IndirectMessageReference)node).isAcked();
    }

    public String toString() {
        return "QueueBrowserSubscription: consumer=" + this.info.getConsumerId() + ", destinations=" + this.destinations.size() + ", dispatched=" + this.dispatched.size() + ", delivered=" + this.delivered + ", matched=" + this.matched.size();
    }

    public void browseDone() throws Throwable {
        this.browseDone = true;
        this.add(IndirectMessageReference.END_OF_BROWSE_MARKER);
    }

    protected MessageDispatch createMessageDispatch(MessageReference node, Message message) {
        if (node == IndirectMessageReference.END_OF_BROWSE_MARKER) {
            MessageDispatch md = new MessageDispatch();
            md.setMessage(null);
            md.setConsumerId(this.info.getConsumerId());
            md.setDestination(null);
            return md;
        }
        return super.createMessageDispatch(node, message);
    }

    public boolean matches(MessageReference node, MessageEvaluationContext context) {
        return !this.browseDone && super.matches(node, context);
    }
}

