/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker.jmx;

import org.activemq.broker.ConnectionContext;
import org.activemq.broker.jmx.ManagedRegionBroker;
import org.activemq.broker.region.Destination;
import org.activemq.broker.region.DestinationStatistics;
import org.activemq.broker.region.TopicRegion;
import org.activemq.broker.region.policy.PolicyMap;
import org.activemq.command.ActiveMQDestination;
import org.activemq.memory.UsageManager;
import org.activemq.store.PersistenceAdapter;
import org.activemq.thread.TaskRunnerFactory;

public class ManagedTopicRegion
extends TopicRegion {
    private final ManagedRegionBroker regionBroker;

    public ManagedTopicRegion(ManagedRegionBroker broker, DestinationStatistics destinationStatistics, UsageManager memoryManager, TaskRunnerFactory taskRunnerFactory, PersistenceAdapter persistenceAdapter, PolicyMap policyMap) {
        super(destinationStatistics, memoryManager, taskRunnerFactory, persistenceAdapter, policyMap);
        this.regionBroker = broker;
    }

    protected Destination createDestination(ActiveMQDestination destination) throws Throwable {
        Destination rc = super.createDestination(destination);
        this.regionBroker.register(destination, rc);
        return rc;
    }

    public void removeDestination(ConnectionContext context, ActiveMQDestination destination, long timeout) throws Throwable {
        super.removeDestination(context, destination, timeout);
        this.regionBroker.unregister(destination);
    }
}

