/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArraySet;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.util.Iterator;
import java.util.Set;
import org.activemq.Service;
import org.activemq.broker.Connection;
import org.activemq.broker.ConnectionContext;
import org.activemq.broker.TransportConnection;
import org.activemq.broker.TransportConnector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransportStatusDetector
implements Service,
Runnable {
    private static final Log log = LogFactory.getLog((Class)TransportStatusDetector.class);
    private TransportConnector connector;
    private Set collectionCandidates = new CopyOnWriteArraySet();
    private AtomicBoolean started = new AtomicBoolean(false);
    private Thread runner;
    private int sweepInterval = 5000;

    TransportStatusDetector(TransportConnector connector) {
        this.connector = connector;
    }

    public int getSweepInterval() {
        return this.sweepInterval;
    }

    public void setSweepInterval(int sweepInterval) {
        this.sweepInterval = sweepInterval;
    }

    protected void doCollection() {
        Iterator i = this.collectionCandidates.iterator();
        while (i.hasNext()) {
            TransportConnection tc = (TransportConnection)i.next();
            if (tc.isMarkedCandidate()) {
                if (tc.isBlockedCandidate()) {
                    this.collectionCandidates.remove(tc);
                    this.doCollection(tc);
                    continue;
                }
                tc.doMark();
                continue;
            }
            this.collectionCandidates.remove(tc);
        }
    }

    protected void doSweep() {
        Iterator i = this.connector.getConnections().iterator();
        while (i.hasNext()) {
            TransportConnection tc;
            ConnectionContext cc = (ConnectionContext)i.next();
            Connection connection = cc.getConnection();
            if (!(connection instanceof TransportConnection) || !(tc = (TransportConnection)connection).isMarkedCandidate()) continue;
            tc.doMark();
            this.collectionCandidates.add(tc);
        }
    }

    protected void doCollection(TransportConnection tc) {
        log.warn((Object)("found a blocked client - stopping: " + tc));
        try {
            tc.stop();
        }
        catch (Exception e) {
            log.error((Object)("Error stopping " + tc), (Throwable)e);
        }
    }

    public void run() {
        while (this.started.get()) {
            try {
                this.doCollection();
                this.doSweep();
                Thread.sleep(this.sweepInterval);
            }
            catch (Throwable e) {
                log.error((Object)"failed to complete a sweep for blocked clients", e);
            }
        }
    }

    public void start() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            this.runner = new Thread((Runnable)this, "Transport Status Dector " + this.connector);
            this.runner.setDaemon(true);
            this.runner.setPriority(9);
            this.runner.start();
        }
    }

    public void stop() throws Exception {
        this.started.set(false);
    }
}

