/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.activemq.ActiveMQConnectionMetaData;
import org.activemq.Service;
import org.activemq.advisory.AdvisoryBroker;
import org.activemq.broker.Broker;
import org.activemq.broker.BrokerRegistry;
import org.activemq.broker.CompositeDestinationBroker;
import org.activemq.broker.ErrorBroker;
import org.activemq.broker.MutableBrokerFilter;
import org.activemq.broker.TransactionBroker;
import org.activemq.broker.TransportConnector;
import org.activemq.broker.UserIDBroker;
import org.activemq.broker.jmx.BrokerView;
import org.activemq.broker.jmx.ConnectorView;
import org.activemq.broker.jmx.ManagedRegionBroker;
import org.activemq.broker.jmx.ManagedTransportConnector;
import org.activemq.broker.jmx.ManagementContext;
import org.activemq.broker.jmx.NetworkConnectorView;
import org.activemq.broker.jmx.ProxyConnectorView;
import org.activemq.broker.region.RegionBroker;
import org.activemq.broker.region.policy.PolicyMap;
import org.activemq.memory.UsageManager;
import org.activemq.network.NetworkConnector;
import org.activemq.network.jms.JmsConnector;
import org.activemq.proxy.ProxyConnector;
import org.activemq.store.DefaultPersistenceAdapterFactory;
import org.activemq.store.PersistenceAdapter;
import org.activemq.store.memory.MemoryPersistenceAdapter;
import org.activemq.thread.TaskRunnerFactory;
import org.activemq.transport.TransportFactory;
import org.activemq.transport.TransportServer;
import org.activemq.util.IOExceptionSupport;
import org.activemq.util.JMXSupport;
import org.activemq.util.ServiceStopper;
import org.activemq.util.URISupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BrokerService
implements Service {
    public static final String DEFAULT_PORT = "61616";
    private static final Log log = LogFactory.getLog((Class)BrokerService.class);
    private boolean useJmx = false;
    private boolean persistent = true;
    private boolean populateJMSXUserID = false;
    private boolean useShutdownHook = true;
    private boolean useLoggingForShutdownErrors = false;
    private String brokerName = "localhost";
    private File dataDirectory;
    private Broker broker;
    private ManagementContext managementContext;
    private ObjectName brokerObjectName;
    private TaskRunnerFactory taskRunnerFactory;
    private UsageManager memoryManager;
    private PersistenceAdapter persistenceAdapter;
    private DefaultPersistenceAdapterFactory persistenceFactory;
    private List transportConnectors = new CopyOnWriteArrayList();
    private List networkConnectors = new CopyOnWriteArrayList();
    private List proxyConnectors = new CopyOnWriteArrayList();
    private List registeredMBeanNames = new CopyOnWriteArrayList();
    private List jmsConnectors = new CopyOnWriteArrayList();
    private Thread shutdownHook;
    private String[] transportConnectorURIs;
    private String[] networkConnectorURIs;
    private String[] proxyConnectorURIs;
    private JmsConnector[] jmsBridgeConnectors;
    private boolean deleteAllMessagesOnStartup;
    private URI vmConnectorURI;
    private PolicyMap destinationPolicy;
    private AtomicBoolean started = new AtomicBoolean(false);

    public TransportConnector addConnector(String bindAddress) throws Exception {
        return this.addConnector(new URI(bindAddress));
    }

    public TransportConnector addConnector(URI bindAddress) throws Exception {
        return this.addConnector(this.createTransportConnector(this.getBroker(), bindAddress));
    }

    public TransportConnector addConnector(TransportServer transport) throws Exception {
        return this.addConnector(new TransportConnector(this.getBroker(), transport));
    }

    public TransportConnector addConnector(TransportConnector connector) throws Exception {
        if (this.isUseJmx()) {
            connector = connector.asManagedConnector(this.getManagementContext().getMBeanServer(), this.getBrokerObjectName());
        }
        connector.setBroker(this.getBroker());
        this.transportConnectors.add(connector);
        if (this.isUseJmx()) {
            this.registerConnectorMBean(connector);
        }
        return connector;
    }

    public NetworkConnector addNetworkConnector(String discoveryAddress) throws Exception {
        return this.addNetworkConnector(new URI(discoveryAddress));
    }

    public ProxyConnector addProxyConnector(String bindAddress) throws Exception {
        return this.addProxyConnector(new URI(bindAddress));
    }

    public NetworkConnector addNetworkConnector(URI discoveryAddress) throws Exception {
        NetworkConnector connector = new NetworkConnector();
        connector.setUri(discoveryAddress);
        return this.addNetworkConnector(connector);
    }

    public ProxyConnector addProxyConnector(URI bindAddress) throws Exception {
        ProxyConnector connector = new ProxyConnector();
        connector.setBind(bindAddress);
        connector.setRemote(new URI("fanout:multicast://default"));
        return this.addProxyConnector(connector);
    }

    public NetworkConnector addNetworkConnector(NetworkConnector connector) throws Exception {
        URI uri = this.getVmConnectorURI();
        HashMap<String, String> map = new HashMap<String, String>(URISupport.parseParamters(uri));
        map.put("network", "true");
        uri = URISupport.createURIWithQuery(uri, URISupport.createQueryString(map));
        connector.setLocalUri(uri);
        connector.setBrokerName(this.getBrokerName());
        this.networkConnectors.add(connector);
        if (this.isUseJmx()) {
            this.registerNetworkConnectorMBean(connector);
        }
        return connector;
    }

    public ProxyConnector addProxyConnector(ProxyConnector connector) throws Exception {
        URI uri = this.getVmConnectorURI();
        connector.setLocalUri(uri);
        this.proxyConnectors.add(connector);
        if (this.isUseJmx()) {
            this.registerProxyConnectorMBean(connector);
        }
        return connector;
    }

    public JmsConnector addJmsConnector(JmsConnector connector) {
        connector.setBrokerService(this);
        this.jmsConnectors.add(connector);
        return connector;
    }

    public JmsConnector removeJmsConnector(JmsConnector connector) {
        if (this.jmsConnectors.remove(connector)) {
            return connector;
        }
        return null;
    }

    public void start() throws Exception {
        Service connector;
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("Allready started.");
        }
        this.processHelperProperties();
        BrokerRegistry.getInstance().bind(this.getBrokerName(), this);
        this.addShutdownHook();
        if (this.deleteAllMessagesOnStartup) {
            this.getPersistenceAdapter().deleteAllMessages();
        }
        if (this.isUseJmx()) {
            this.getManagementContext().start();
        }
        this.getBroker().start();
        Iterator iter = this.getTransportConnectors().iterator();
        while (iter.hasNext()) {
            connector = (TransportConnector)iter.next();
            ((TransportConnector)connector).start();
        }
        iter = this.getNetworkConnectors().iterator();
        while (iter.hasNext()) {
            connector = (NetworkConnector)iter.next();
            ((NetworkConnector)connector).start();
        }
        iter = this.getProxyConnectors().iterator();
        while (iter.hasNext()) {
            connector = (ProxyConnector)iter.next();
            ((ProxyConnector)connector).start();
        }
        iter = this.jmsConnectors.iterator();
        while (iter.hasNext()) {
            connector = (JmsConnector)iter.next();
            ((JmsConnector)connector).start();
        }
        log.info((Object)("ActiveMQ JMS Message Broker (" + this.getBrokerName() + ") started"));
    }

    public void stop() throws Exception {
        Service connector;
        if (!this.started.compareAndSet(true, false)) {
            return;
        }
        log.info((Object)("ActiveMQ Message Broker (" + this.getBrokerName() + ") is shutting down"));
        BrokerRegistry.getInstance().unbind(this.getBrokerName());
        this.removeShutdownHook();
        ServiceStopper stopper = new ServiceStopper();
        Iterator iter = this.getTransportConnectors().iterator();
        while (iter.hasNext()) {
            connector = (TransportConnector)iter.next();
            stopper.stop(connector);
        }
        iter = this.getNetworkConnectors().iterator();
        while (iter.hasNext()) {
            connector = (NetworkConnector)iter.next();
            stopper.stop(connector);
        }
        iter = this.getProxyConnectors().iterator();
        while (iter.hasNext()) {
            connector = (ProxyConnector)iter.next();
            stopper.stop(connector);
        }
        iter = this.jmsConnectors.iterator();
        while (iter.hasNext()) {
            connector = (JmsConnector)iter.next();
            stopper.stop(connector);
        }
        stopper.stop(this.getPersistenceAdapter());
        if (this.broker != null) {
            stopper.stop(this.broker);
        }
        if (this.isUseJmx()) {
            MBeanServer mbeanServer = this.getManagementContext().getMBeanServer();
            Iterator iter2 = this.registeredMBeanNames.iterator();
            while (iter2.hasNext()) {
                ObjectName name = (ObjectName)iter2.next();
                try {
                    mbeanServer.unregisterMBean(name);
                }
                catch (Exception e) {
                    stopper.onException(mbeanServer, e);
                }
            }
            stopper.stop(this.getManagementContext());
        }
        log.info((Object)("ActiveMQ JMS Message Broker (" + this.getBrokerName() + ") stopped"));
        stopper.throwFirstException();
    }

    public Broker getBroker() throws Exception {
        if (this.broker == null) {
            log.info((Object)("ActiveMQ " + ActiveMQConnectionMetaData.PROVIDER_VERSION + " JMS Message Broker (" + this.getBrokerName() + ") is starting"));
            log.info((Object)"For help or more information please see: http://www.logicblaze.com");
            this.broker = this.createBroker();
        }
        return this.broker;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    public DefaultPersistenceAdapterFactory getPersistenceFactory() {
        if (this.persistenceFactory == null) {
            this.persistenceFactory = this.createPersistenceFactory();
        }
        return this.persistenceFactory;
    }

    public File getDataDirectory() {
        if (this.dataDirectory == null) {
            this.dataDirectory = new File(new File("activemq-data"), this.getBrokerName().replaceAll("[^a-zA-Z0-9\\.\\_\\-]", "_"));
        }
        return this.dataDirectory;
    }

    public void setDataDirectory(File dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    public void setPersistenceFactory(DefaultPersistenceAdapterFactory persistenceFactory) {
        this.persistenceFactory = persistenceFactory;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public boolean isPopulateJMSXUserID() {
        return this.populateJMSXUserID;
    }

    public void setPopulateJMSXUserID(boolean populateJMSXUserID) {
        this.populateJMSXUserID = populateJMSXUserID;
    }

    public UsageManager getMemoryManager() {
        if (this.memoryManager == null) {
            this.memoryManager = new UsageManager();
            this.memoryManager.setLimit(0x1400000L);
        }
        return this.memoryManager;
    }

    public void setMemoryManager(UsageManager memoryManager) {
        this.memoryManager = memoryManager;
    }

    public PersistenceAdapter getPersistenceAdapter() throws IOException {
        if (this.persistenceAdapter == null) {
            this.persistenceAdapter = this.createPersistenceAdapter();
        }
        return this.persistenceAdapter;
    }

    public void setPersistenceAdapter(PersistenceAdapter persistenceAdapter) {
        this.persistenceAdapter = persistenceAdapter;
    }

    public TaskRunnerFactory getTaskRunnerFactory() {
        if (this.taskRunnerFactory == null) {
            this.taskRunnerFactory = new TaskRunnerFactory();
        }
        return this.taskRunnerFactory;
    }

    public void setTaskRunnerFactory(TaskRunnerFactory taskRunnerFactory) {
        this.taskRunnerFactory = taskRunnerFactory;
    }

    public boolean isUseJmx() {
        return this.useJmx;
    }

    public void setUseJmx(boolean useJmx) {
        this.useJmx = useJmx;
    }

    public ObjectName getBrokerObjectName() throws IOException {
        if (this.brokerObjectName == null) {
            this.brokerObjectName = this.createBrokerObjectName();
        }
        return this.brokerObjectName;
    }

    public void setBrokerObjectName(ObjectName brokerObjectName) {
        this.brokerObjectName = brokerObjectName;
    }

    public ManagementContext getManagementContext() {
        if (this.managementContext == null) {
            this.managementContext = new ManagementContext();
        }
        return this.managementContext;
    }

    public void setManagementContext(ManagementContext managementContext) {
        this.managementContext = managementContext;
    }

    public String[] getNetworkConnectorURIs() {
        return this.networkConnectorURIs;
    }

    public void setNetworkConnectorURIs(String[] networkConnectorURIs) {
        this.networkConnectorURIs = networkConnectorURIs;
    }

    public String[] getTransportConnectorURIs() {
        return this.transportConnectorURIs;
    }

    public void setTransportConnectorURIs(String[] transportConnectorURIs) {
        this.transportConnectorURIs = transportConnectorURIs;
    }

    public JmsConnector[] getJmsBridgeConnectors() {
        return this.jmsBridgeConnectors;
    }

    public void setJmsBridgeConnectors(JmsConnector[] jmsConnectors) {
        this.jmsBridgeConnectors = jmsConnectors;
    }

    public boolean isUseLoggingForShutdownErrors() {
        return this.useLoggingForShutdownErrors;
    }

    public void setUseLoggingForShutdownErrors(boolean useLoggingForShutdownErrors) {
        this.useLoggingForShutdownErrors = useLoggingForShutdownErrors;
    }

    public boolean isUseShutdownHook() {
        return this.useShutdownHook;
    }

    public void setUseShutdownHook(boolean useShutdownHook) {
        this.useShutdownHook = useShutdownHook;
    }

    public List getTransportConnectors() {
        return new ArrayList(this.transportConnectors);
    }

    public void setTransportConnectors(List transportConnectors) throws Exception {
        Iterator iter = transportConnectors.iterator();
        while (iter.hasNext()) {
            TransportConnector connector = (TransportConnector)iter.next();
            connector.setBroker(this.getBroker());
            connector.setBrokerName(this.getBrokerName());
            this.addConnector(connector);
        }
    }

    public List getNetworkConnectors() {
        return new ArrayList(this.networkConnectors);
    }

    public List getProxyConnectors() {
        return new ArrayList(this.proxyConnectors);
    }

    public void setNetworkConnectors(List networkConnectors) throws Exception {
        Iterator iter = networkConnectors.iterator();
        while (iter.hasNext()) {
            NetworkConnector connector = (NetworkConnector)iter.next();
            this.addNetworkConnector(connector);
        }
    }

    public void setProxyConnectors(List proxyConnectors) throws Exception {
        Iterator iter = proxyConnectors.iterator();
        while (iter.hasNext()) {
            ProxyConnector connector = (ProxyConnector)iter.next();
            this.addProxyConnector(connector);
        }
    }

    public PolicyMap getDestinationPolicy() {
        return this.destinationPolicy;
    }

    public void setDestinationPolicy(PolicyMap policyMap) {
        this.destinationPolicy = policyMap;
    }

    protected void processHelperProperties() throws Exception {
        String uri;
        int i;
        if (this.transportConnectorURIs != null) {
            for (i = 0; i < this.transportConnectorURIs.length; ++i) {
                uri = this.transportConnectorURIs[i];
                this.addConnector(uri);
            }
        }
        if (this.networkConnectorURIs != null) {
            for (i = 0; i < this.transportConnectorURIs.length; ++i) {
                uri = this.transportConnectorURIs[i];
                this.addNetworkConnector(uri);
            }
        }
        if (this.proxyConnectorURIs != null) {
            for (i = 0; i < this.proxyConnectorURIs.length; ++i) {
                uri = this.proxyConnectorURIs[i];
                this.addProxyConnector(uri);
            }
        }
        if (this.jmsBridgeConnectors != null) {
            for (i = 0; i < this.jmsBridgeConnectors.length; ++i) {
                this.addJmsConnector(this.jmsBridgeConnectors[i]);
            }
        }
    }

    protected void registerConnectorMBean(TransportConnector connector) throws IOException, URISyntaxException {
        MBeanServer mbeanServer = this.getManagementContext().getMBeanServer();
        ConnectorView view = new ConnectorView(connector);
        Hashtable<String, String> map = new Hashtable<String, String>();
        map.put("Type", "Connector");
        map.put("BrokerName", JMXSupport.encodeObjectNamePart(this.getBrokerName()));
        map.put("ConnectorName", JMXSupport.encodeObjectNamePart(connector.getName()));
        try {
            ObjectName objectName = new ObjectName("org.activemq", map);
            mbeanServer.registerMBean(view, objectName);
            this.registeredMBeanNames.add(objectName);
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create("Broker could not be registered in JMX: " + e.getMessage(), e);
        }
    }

    protected void registerNetworkConnectorMBean(NetworkConnector connector) throws IOException {
        MBeanServer mbeanServer = this.getManagementContext().getMBeanServer();
        NetworkConnectorView view = new NetworkConnectorView(connector);
        Hashtable<String, String> map = new Hashtable<String, String>();
        map.put("Type", "NetworkConnector");
        map.put("BrokerName", JMXSupport.encodeObjectNamePart(this.getBrokerName()));
        try {
            ObjectName objectName = new ObjectName("org.activemq", map);
            mbeanServer.registerMBean(view, objectName);
            this.registeredMBeanNames.add(objectName);
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create("Broker could not be registered in JMX: " + e.getMessage(), e);
        }
    }

    protected void registerProxyConnectorMBean(ProxyConnector connector) throws IOException {
        MBeanServer mbeanServer = this.getManagementContext().getMBeanServer();
        ProxyConnectorView view = new ProxyConnectorView(connector);
        Hashtable<String, String> map = new Hashtable<String, String>();
        map.put("Type", "ProxyConnector");
        map.put("BrokerName", JMXSupport.encodeObjectNamePart(this.getBrokerName()));
        try {
            ObjectName objectName = new ObjectName("org.activemq", map);
            mbeanServer.registerMBean(view, objectName);
            this.registeredMBeanNames.add(objectName);
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create("Broker could not be registered in JMX: " + e.getMessage(), e);
        }
    }

    protected Broker createBroker() throws Exception {
        Broker regionBroker = this.createRegionBroker();
        Broker broker = this.addInterceptors(regionBroker);
        broker = new MutableBrokerFilter(broker){

            public void stop() throws Exception {
                super.stop();
                this.setNext(new ErrorBroker("Broker has been stopped."){

                    public void stop() throws Exception {
                    }
                });
            }
        };
        if (this.isUseJmx()) {
            ManagedRegionBroker managedBroker = (ManagedRegionBroker)regionBroker;
            BrokerView view = new BrokerView(broker, managedBroker.getDestinationStatistics(), this.getMemoryManager());
            MBeanServer mbeanServer = this.getManagementContext().getMBeanServer();
            ObjectName objectName = this.getBrokerObjectName();
            mbeanServer.registerMBean(view, objectName);
            this.registeredMBeanNames.add(objectName);
        }
        return broker;
    }

    protected Broker createRegionBroker() throws Exception {
        this.getPersistenceAdapter().start();
        RegionBroker regionBroker = null;
        if (this.isUseJmx()) {
            MBeanServer mbeanServer = this.getManagementContext().getMBeanServer();
            regionBroker = new ManagedRegionBroker(mbeanServer, this.getBrokerObjectName(), this.getTaskRunnerFactory(), this.getMemoryManager(), this.getPersistenceAdapter(), this.getDestinationPolicy());
        } else {
            regionBroker = new RegionBroker(this.getTaskRunnerFactory(), this.getMemoryManager(), this.getPersistenceAdapter(), this.getDestinationPolicy());
        }
        regionBroker.setBrokerName(this.getBrokerName());
        return regionBroker;
    }

    protected Broker addInterceptors(Broker broker) throws IOException {
        broker = new TransactionBroker(broker, this.getPersistenceAdapter().createTransactionStore());
        broker = new AdvisoryBroker(broker);
        broker = new CompositeDestinationBroker(broker);
        if (this.isPopulateJMSXUserID()) {
            broker = new UserIDBroker(broker);
        }
        return broker;
    }

    protected PersistenceAdapter createPersistenceAdapter() throws IOException {
        if (this.isPersistent()) {
            return this.getPersistenceFactory().createPersistenceAdapter();
        }
        return new MemoryPersistenceAdapter();
    }

    protected DefaultPersistenceAdapterFactory createPersistenceFactory() {
        DefaultPersistenceAdapterFactory factory = new DefaultPersistenceAdapterFactory();
        factory.setMemManager(this.getMemoryManager());
        factory.setDataDirectory(this.getDataDirectory());
        factory.setTaskRunnerFactory(this.getTaskRunnerFactory());
        return factory;
    }

    protected ObjectName createBrokerObjectName() throws IOException {
        try {
            Hashtable<String, String> map = new Hashtable<String, String>();
            map.put("Type", "Broker");
            map.put("BrokerName", JMXSupport.encodeObjectNamePart(this.getBrokerName()));
            return new ObjectName("org.activemq", map);
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create("Invalid JMX broker name: " + this.brokerName, e);
        }
    }

    protected TransportConnector createTransportConnector(Broker broker, URI brokerURI) throws Exception {
        TransportServer transport = TransportFactory.bind(this.getBrokerName(), brokerURI);
        if (this.isUseJmx()) {
            MBeanServer mbeanServer = this.getManagementContext().getMBeanServer();
            return new ManagedTransportConnector(mbeanServer, this.getBrokerObjectName(), broker, transport);
        }
        return new TransportConnector(broker, transport);
    }

    protected Object getPort(Map options) {
        Object port = options.get("port");
        if (port == null) {
            port = DEFAULT_PORT;
            log.warn((Object)("No port specified so defaulting to: " + port));
        }
        return port;
    }

    protected void addShutdownHook() {
        if (this.useShutdownHook) {
            this.shutdownHook = new Thread("ActiveMQ ShutdownHook"){

                public void run() {
                    BrokerService.this.containerShutdown();
                }
            };
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
    }

    protected void removeShutdownHook() {
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (Exception e) {
                log.debug((Object)("Caught exception, must be shutting down: " + e));
            }
        }
    }

    protected void containerShutdown() {
        try {
            this.stop();
        }
        catch (IOException e) {
            Throwable linkedException = e.getCause();
            if (linkedException != null) {
                this.logError("Failed to shut down: " + e + ". Reason: " + linkedException, linkedException);
            } else {
                this.logError("Failed to shut down: " + e, e);
            }
            if (!this.useLoggingForShutdownErrors) {
                e.printStackTrace(System.err);
            }
        }
        catch (Exception e) {
            this.logError("Failed to shut down: " + e, e);
        }
    }

    protected void logError(String message, Throwable e) {
        if (this.useLoggingForShutdownErrors) {
            log.error((Object)("Failed to shut down: " + e));
        } else {
            System.err.println("Failed to shut down: " + e);
        }
    }

    public boolean isDeleteAllMessagesOnStartup() {
        return this.deleteAllMessagesOnStartup;
    }

    public void setDeleteAllMessagesOnStartup(boolean deletePersistentMessagesOnStartup) {
        this.deleteAllMessagesOnStartup = deletePersistentMessagesOnStartup;
    }

    public URI getVmConnectorURI() {
        if (this.vmConnectorURI == null) {
            try {
                this.vmConnectorURI = new URI("vm://" + this.getBrokerName());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return this.vmConnectorURI;
    }

    public void setVmConnectorURI(URI vmConnectorURI) {
        this.vmConnectorURI = vmConnectorURI;
    }
}

