/*
 * Decompiled with CFR 0.152.
 */
package org.activemq;

import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.activemq.ActiveMQConnection;
import org.activemq.command.ActiveMQBytesMessage;
import org.activemq.command.ActiveMQDestination;
import org.activemq.command.ActiveMQMapMessage;
import org.activemq.command.ActiveMQMessage;
import org.activemq.command.ActiveMQObjectMessage;
import org.activemq.command.ActiveMQQueue;
import org.activemq.command.ActiveMQStreamMessage;
import org.activemq.command.ActiveMQTempQueue;
import org.activemq.command.ActiveMQTempTopic;
import org.activemq.command.ActiveMQTextMessage;
import org.activemq.command.ActiveMQTopic;

class ActiveMQMessageTransformation {
    ActiveMQMessageTransformation() {
    }

    public static ActiveMQDestination transformDestination(Destination destination) throws JMSException {
        ActiveMQDestination activeMQDestination = null;
        if (destination != null) {
            if (destination instanceof ActiveMQDestination) {
                return (ActiveMQDestination)destination;
            }
            if (destination instanceof TemporaryQueue) {
                activeMQDestination = new ActiveMQTempQueue(((Queue)destination).getQueueName());
            } else if (destination instanceof TemporaryTopic) {
                activeMQDestination = new ActiveMQTempTopic(((Topic)destination).getTopicName());
            } else if (destination instanceof Queue) {
                activeMQDestination = new ActiveMQQueue(((Queue)destination).getQueueName());
            } else if (destination instanceof Topic) {
                activeMQDestination = new ActiveMQTopic(((Topic)destination).getTopicName());
            }
        }
        return activeMQDestination;
    }

    public static final ActiveMQMessage transformMessage(Message message, ActiveMQConnection connection) throws JMSException {
        Object obj;
        ActiveMQMessage msg;
        if (message instanceof ActiveMQMessage) {
            return (ActiveMQMessage)message;
        }
        ActiveMQMessage activeMessage = null;
        if (message instanceof BytesMessage) {
            BytesMessage bytesMsg = (BytesMessage)message;
            bytesMsg.reset();
            msg = new ActiveMQBytesMessage();
            msg.setConnection(connection);
            try {
                while (true) {
                    ((ActiveMQBytesMessage)msg).writeByte(bytesMsg.readByte());
                }
            }
            catch (MessageEOFException e) {
            }
            catch (JMSException e) {
                // empty catch block
            }
            activeMessage = msg;
        } else if (message instanceof MapMessage) {
            MapMessage mapMsg = (MapMessage)message;
            msg = new ActiveMQMapMessage();
            msg.setConnection(connection);
            Enumeration iter = mapMsg.getMapNames();
            while (iter.hasMoreElements()) {
                String name = iter.nextElement().toString();
                ((ActiveMQMapMessage)msg).setObject(name, mapMsg.getObject(name));
            }
            activeMessage = msg;
        } else if (message instanceof ObjectMessage) {
            ObjectMessage objMsg = (ObjectMessage)message;
            msg = new ActiveMQObjectMessage();
            msg.setConnection(connection);
            ((ActiveMQObjectMessage)msg).setObject(objMsg.getObject());
            ((ActiveMQObjectMessage)msg).storeContent();
            activeMessage = msg;
        } else if (message instanceof StreamMessage) {
            StreamMessage streamMessage = (StreamMessage)message;
            streamMessage.reset();
            msg = new ActiveMQStreamMessage();
            msg.setConnection(connection);
            obj = null;
            try {
                while ((obj = streamMessage.readObject()) != null) {
                    ((ActiveMQStreamMessage)msg).writeObject(obj);
                }
            }
            catch (MessageEOFException e) {
            }
            catch (JMSException e) {
                // empty catch block
            }
            activeMessage = msg;
        } else if (message instanceof TextMessage) {
            TextMessage textMsg = (TextMessage)message;
            msg = new ActiveMQTextMessage();
            msg.setConnection(connection);
            ((ActiveMQTextMessage)msg).setText(textMsg.getText());
            activeMessage = msg;
        } else {
            activeMessage = new ActiveMQMessage();
            activeMessage.setConnection(connection);
        }
        activeMessage.setJMSMessageID(message.getJMSMessageID());
        activeMessage.setJMSCorrelationID(message.getJMSCorrelationID());
        activeMessage.setJMSReplyTo(ActiveMQMessageTransformation.transformDestination(message.getJMSReplyTo()));
        activeMessage.setJMSDestination(ActiveMQMessageTransformation.transformDestination(message.getJMSDestination()));
        activeMessage.setJMSDeliveryMode(message.getJMSDeliveryMode());
        activeMessage.setJMSRedelivered(message.getJMSRedelivered());
        activeMessage.setJMSType(message.getJMSType());
        activeMessage.setJMSExpiration(message.getJMSExpiration());
        activeMessage.setJMSPriority(message.getJMSPriority());
        activeMessage.setJMSTimestamp(message.getJMSTimestamp());
        Enumeration propertyNames = message.getPropertyNames();
        while (propertyNames.hasMoreElements()) {
            String name = propertyNames.nextElement().toString();
            obj = message.getObjectProperty(name);
            activeMessage.setObjectProperty(name, obj);
        }
        return activeMessage;
    }
}

