/*
 * Decompiled with CFR 0.152.
 */
package org.activemq;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicLong;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import org.activeio.Disposable;
import org.activemq.ActiveMQSession;
import org.activemq.Closeable;
import org.activemq.command.ActiveMQDestination;
import org.activemq.command.ProducerId;
import org.activemq.command.ProducerInfo;
import org.activemq.management.JMSProducerStatsImpl;
import org.activemq.management.StatsCapable;
import org.activemq.management.StatsImpl;

public class ActiveMQMessageProducer
implements MessageProducer,
StatsCapable,
Closeable,
Disposable {
    protected ActiveMQSession session;
    protected ProducerInfo info;
    private JMSProducerStatsImpl stats;
    private AtomicLong messageSequence;
    protected boolean closed;
    private boolean disableMessageID;
    private boolean disableMessageTimestamp;
    private int defaultDeliveryMode;
    private int defaultPriority;
    private long defaultTimeToLive;
    private long startTime;

    protected ActiveMQMessageProducer(ActiveMQSession session, ProducerId producerId, ActiveMQDestination destination) throws JMSException {
        this.session = session;
        this.info = new ProducerInfo(producerId);
        this.info.setDestination(destination);
        this.disableMessageID = false;
        this.disableMessageTimestamp = session.connection.isDisableTimeStampsByDefault();
        this.defaultDeliveryMode = 2;
        this.defaultPriority = 4;
        this.defaultTimeToLive = 0L;
        this.startTime = System.currentTimeMillis();
        this.messageSequence = new AtomicLong(0L);
        this.stats = new JMSProducerStatsImpl(session.getSessionStats(), destination);
        this.session.addProducer(this);
        this.session.asyncSendPacket(this.info);
    }

    public StatsImpl getStats() {
        return this.stats;
    }

    public JMSProducerStatsImpl getProducerStats() {
        return this.stats;
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.checkClosed();
        this.disableMessageID = value;
    }

    public boolean getDisableMessageID() throws JMSException {
        this.checkClosed();
        return this.disableMessageID;
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.checkClosed();
        this.disableMessageTimestamp = value;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        this.checkClosed();
        return this.disableMessageTimestamp;
    }

    public void setDeliveryMode(int newDeliveryMode) throws JMSException {
        if (newDeliveryMode != 2 && newDeliveryMode != 1) {
            throw new IllegalStateException("unkown delivery mode: " + newDeliveryMode);
        }
        this.checkClosed();
        this.defaultDeliveryMode = newDeliveryMode;
    }

    public int getDeliveryMode() throws JMSException {
        this.checkClosed();
        return this.defaultDeliveryMode;
    }

    public void setPriority(int newDefaultPriority) throws JMSException {
        if (newDefaultPriority < 0 || newDefaultPriority > 9) {
            throw new IllegalStateException("default priority must be a value between 0 and 9");
        }
        this.checkClosed();
        this.defaultPriority = newDefaultPriority;
    }

    public int getPriority() throws JMSException {
        this.checkClosed();
        return this.defaultPriority;
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        if (timeToLive < 0L) {
            throw new IllegalStateException("cannot set a negative timeToLive");
        }
        this.checkClosed();
        this.defaultTimeToLive = timeToLive;
    }

    public long getTimeToLive() throws JMSException {
        this.checkClosed();
        return this.defaultTimeToLive;
    }

    public Destination getDestination() throws JMSException {
        this.checkClosed();
        return this.info.getDestination();
    }

    public void close() throws JMSException {
        if (!this.closed) {
            this.dispose();
            this.session.asyncSendPacket(this.info.createRemoveCommand());
        }
    }

    public void dispose() {
        if (!this.closed) {
            this.session.removeProducer(this);
            this.closed = true;
        }
    }

    protected void checkClosed() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("The producer is closed");
        }
    }

    public void send(Message message) throws JMSException {
        this.send(this.getDestination(), message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTimeToLive);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send(this.getDestination(), message, deliveryMode, priority, timeToLive);
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.send(destination, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTimeToLive);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        ActiveMQDestination dest;
        this.checkClosed();
        if (destination == null) {
            if (this.info.getDestination() == null) {
                throw new UnsupportedOperationException("A destination must be specified.");
            }
            throw new InvalidDestinationException("Don't understand null destinations");
        }
        if (destination == this.info.getDestination()) {
            dest = (ActiveMQDestination)destination;
        } else if (this.info.getDestination() == null) {
            dest = ActiveMQDestination.transform(destination);
        } else {
            throw new UnsupportedOperationException("This producer can only send messages to: " + this.info.getDestination().getPhysicalName());
        }
        this.session.send(this, dest, message, deliveryMode, priority, timeToLive);
        this.stats.onMessage();
    }

    protected long getStartTime() {
        return this.startTime;
    }

    protected long getMessageSequence() {
        return this.messageSequence.incrementAndGet();
    }

    protected void setMessageSequence(AtomicLong messageSequence) {
        this.messageSequence = messageSequence;
    }

    protected ProducerInfo getProducerInfo() {
        return this.info != null ? this.info : null;
    }

    protected void setProducerInfo(ProducerInfo info) {
        this.info = info;
    }
}

