/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.util;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class IntrospectionSupport {
    public static boolean setProperties(Object target, Map props, String optionPrefix) {
        boolean rc = false;
        if (target == null) {
            throw new IllegalArgumentException("target was null.");
        }
        if (props == null) {
            throw new IllegalArgumentException("props was null.");
        }
        Iterator iter = props.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (!name.startsWith(optionPrefix)) continue;
            Object value = props.get(name);
            if (!IntrospectionSupport.setProperty(target, name = name.substring(optionPrefix.length()), value)) continue;
            iter.remove();
            rc = true;
        }
        return rc;
    }

    public static Map extractProperties(Map props, String optionPrefix) {
        if (props == null) {
            throw new IllegalArgumentException("props was null.");
        }
        HashMap rc = new HashMap(props.size());
        Iterator iter = props.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (!name.startsWith(optionPrefix)) continue;
            Object value = props.get(name);
            name = name.substring(optionPrefix.length());
            rc.put(name, value);
            iter.remove();
        }
        return rc;
    }

    public static void setProperties(Object target, Map props) {
        if (target == null) {
            throw new IllegalArgumentException("target was null.");
        }
        if (props == null) {
            throw new IllegalArgumentException("props was null.");
        }
        Iterator iter = props.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!IntrospectionSupport.setProperty(target, (String)entry.getKey(), entry.getValue())) continue;
            iter.remove();
        }
    }

    private static boolean setProperty(Object target, String name, Object value) {
        try {
            Class<?> clazz = target.getClass();
            Method setter = IntrospectionSupport.findSetterMethod(clazz, name);
            if (setter == null) {
                return false;
            }
            if (value == null || value.getClass() == setter.getParameterTypes()[0]) {
                setter.invoke(target, value);
            } else {
                setter.invoke(target, IntrospectionSupport.convert(value, setter.getParameterTypes()[0]));
            }
            return true;
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    private static Object convert(Object value, Class type) throws URISyntaxException {
        PropertyEditor editor = PropertyEditorManager.findEditor(type);
        if (editor != null) {
            editor.setAsText(value.toString());
            return editor.getValue();
        }
        if (type == URI.class) {
            return new URI(value.toString());
        }
        return null;
    }

    private static Method findSetterMethod(Class clazz, String name) {
        name = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            Class<?>[] params = method.getParameterTypes();
            if (!method.getName().equals(name) || params.length != 1 || !IntrospectionSupport.isSettableType(params[0])) continue;
            return method;
        }
        return null;
    }

    private static boolean isSettableType(Class clazz) {
        if (PropertyEditorManager.findEditor(clazz) != null) {
            return true;
        }
        return clazz == URI.class;
    }
}

