/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.vm;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import java.io.IOException;
import java.net.URI;
import org.activemq.command.BrokerInfo;
import org.activemq.transport.MutexTransport;
import org.activemq.transport.ResponseCorrelator;
import org.activemq.transport.Transport;
import org.activemq.transport.TransportAcceptListener;
import org.activemq.transport.TransportServer;
import org.activemq.transport.vm.VMTransport;
import org.activemq.transport.vm.VMTransportFactory;

public class VMTransportServer
implements TransportServer {
    private TransportAcceptListener acceptListener;
    private final URI location;
    private boolean disposed;
    private final AtomicInteger connectionCount = new AtomicInteger(0);
    private final boolean disposeOnDisconnect;

    public VMTransportServer(URI location, boolean disposeOnDisconnect) {
        this.location = location;
        this.disposeOnDisconnect = disposeOnDisconnect;
    }

    public String toString() {
        return "VMTransportServer(" + this.location + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VMTransport connect() throws IOException {
        TransportAcceptListener al;
        VMTransportServer vMTransportServer = this;
        synchronized (vMTransportServer) {
            if (this.disposed) {
                throw new IOException("Server has been disposed.");
            }
            al = this.acceptListener;
        }
        if (al == null) {
            throw new IOException("Server TransportAcceptListener is null.");
        }
        this.connectionCount.incrementAndGet();
        VMTransport client = new VMTransport(){

            public void stop() throws Exception {
                if (this.disposed) {
                    return;
                }
                super.stop();
                if (VMTransportServer.this.connectionCount.decrementAndGet() == 0 && VMTransportServer.this.disposeOnDisconnect) {
                    VMTransportServer.this.stop();
                }
            }
        };
        VMTransport server = new VMTransport();
        client.setPeer(server);
        server.setPeer(client);
        al.onAccept(VMTransportServer.configure(server));
        return client;
    }

    public static Transport configure(Transport transport) {
        transport = new MutexTransport(transport);
        transport = new ResponseCorrelator(transport);
        return transport;
    }

    public synchronized void setAcceptListener(TransportAcceptListener acceptListener) {
        this.acceptListener = acceptListener;
    }

    public void start() throws IOException {
    }

    public void stop() throws IOException {
        VMTransportFactory.stopped(this);
    }

    public URI getConnectURI() {
        return this.location;
    }

    public URI getBindURI() {
        return this.location;
    }

    public void setBrokerInfo(BrokerInfo brokerInfo) {
    }
}

