/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.activeio.command.WireFormat;
import org.activeio.command.WireFormatFactory;
import org.activemq.command.BrokerInfo;
import org.activemq.openwire.OpenWireFormatFactory;
import org.activemq.transport.TransportServerThreadSupport;
import org.activemq.transport.tcp.TcpTransport;
import org.activemq.transport.tcp.TcpTransportFactory;
import org.activemq.util.ServiceStopper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TcpTransportServer
extends TransportServerThreadSupport {
    private static final Log log = LogFactory.getLog((Class)TcpTransportServer.class);
    private ServerSocket serverSocket;
    private int backlog = 5000;
    private WireFormatFactory wireFormatFactory = new OpenWireFormatFactory();
    private TcpTransportFactory transportFactory = new TcpTransportFactory();

    public TcpTransportServer(URI location) throws IOException, URISyntaxException {
        super(location);
        this.serverSocket = this.createServerSocket(location);
        this.serverSocket.setSoTimeout(2000);
        this.updatePhysicalUri(location);
    }

    public WireFormatFactory getWireFormatFactory() {
        return this.wireFormatFactory;
    }

    public void setWireFormatFactory(WireFormatFactory wireFormatFactory) {
        this.wireFormatFactory = wireFormatFactory;
    }

    public void setBrokerInfo(BrokerInfo brokerInfo) {
    }

    public void run() {
        while (!this.isClosed()) {
            Socket socket = null;
            try {
                socket = this.serverSocket.accept();
                if (socket == null) continue;
                if (this.isClosed() || this.getAcceptListener() == null) {
                    socket.close();
                    continue;
                }
                HashMap options = new HashMap();
                WireFormat format = this.wireFormatFactory.createWireFormat();
                TcpTransport transport = new TcpTransport(format, socket);
                this.getAcceptListener().onAccept(this.transportFactory.configure(transport, format, options));
            }
            catch (SocketTimeoutException ste) {
            }
            catch (Exception e) {
                if (!this.isClosing()) {
                    this.onAcceptError(e);
                    continue;
                }
                if (this.isClosed()) continue;
                log.warn((Object)"run()", (Throwable)e);
                this.onAcceptError(e);
            }
        }
    }

    public String toString() {
        return "TcpTransportServer@" + this.getLocation();
    }

    protected void updatePhysicalUri(URI bindAddr) throws URISyntaxException, UnknownHostException {
        this.setLocation(new URI(bindAddr.getScheme(), bindAddr.getUserInfo(), this.resolveHostName(bindAddr.getHost()), this.serverSocket.getLocalPort(), bindAddr.getPath(), bindAddr.getQuery(), bindAddr.getFragment()));
    }

    protected String resolveHostName(String hostName) throws UnknownHostException {
        String result = hostName;
        if (hostName != null && (hostName.equalsIgnoreCase("localhost") || hostName.equals("127.0.0.1"))) {
            result = InetAddress.getLocalHost().getHostName();
        }
        return result;
    }

    protected ServerSocket createServerSocket(URI bind) throws UnknownHostException, IOException {
        ServerSocket answer = null;
        String host = bind.getHost();
        host = host == null || host.length() == 0 ? "localhost" : host;
        InetAddress addr = InetAddress.getByName(host);
        answer = host.trim().equals("localhost") || addr.equals(InetAddress.getLocalHost()) ? new ServerSocket(bind.getPort(), this.backlog) : new ServerSocket(bind.getPort(), this.backlog, addr);
        return answer;
    }

    protected void doStop(ServiceStopper stopper) throws Exception {
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
    }
}

