/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.tcp;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import org.activeio.command.WireFormat;
import org.activemq.transport.MutexTransport;
import org.activemq.transport.ResponseCorrelator;
import org.activemq.transport.Transport;
import org.activemq.transport.TransportFactory;
import org.activemq.transport.TransportLogger;
import org.activemq.transport.TransportServer;
import org.activemq.transport.WireFormatNegotiator;
import org.activemq.transport.tcp.TcpTransport;
import org.activemq.transport.tcp.TcpTransportServer;
import org.activemq.util.IOExceptionSupport;
import org.activemq.util.IntrospectionSupport;
import org.activemq.util.URISupport;

public class TcpTransportFactory
extends TransportFactory {
    public TransportServer doBind(String brokerId, URI location) throws IOException {
        try {
            HashMap options = new HashMap(URISupport.parseParamters(location));
            TcpTransportServer server = new TcpTransportServer(location);
            server.setWireFormatFactory(this.createWireFormatFactory(options));
            IntrospectionSupport.setProperties(server, options);
            return server;
        }
        catch (URISyntaxException e) {
            throw IOExceptionSupport.create(e);
        }
    }

    public Transport configure(Transport transport, WireFormat format, Map options) {
        IntrospectionSupport.setProperties(transport, options);
        TcpTransport tcpTransport = (TcpTransport)transport;
        if (tcpTransport.isTrace()) {
            transport = new TransportLogger(transport);
        }
        transport = new WireFormatNegotiator(transport, format, tcpTransport.getMinmumWireFormatVersion());
        transport = new MutexTransport(transport);
        transport = new ResponseCorrelator(transport);
        return transport;
    }

    public Transport compositeConfigure(Transport transport, WireFormat format, Map options) {
        IntrospectionSupport.setProperties(transport, options);
        TcpTransport tcpTransport = (TcpTransport)transport;
        if (tcpTransport.isTrace()) {
            transport = new TransportLogger(transport);
        }
        transport = new WireFormatNegotiator(transport, format, tcpTransport.getMinmumWireFormatVersion());
        return transport;
    }

    protected Transport createTransport(URI location, WireFormat wf) throws UnknownHostException, IOException {
        return new TcpTransport(wf, location);
    }

    protected ServerSocketFactory createServerSocketFactory() {
        return ServerSocketFactory.getDefault();
    }

    protected SocketFactory createSocketFactory() {
        return SocketFactory.getDefault();
    }
}

