/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.stomp;

import java.io.DataInput;
import java.io.IOException;
import java.util.Properties;
import org.activemq.command.ActiveMQDestination;
import org.activemq.command.ConsumerId;
import org.activemq.command.ConsumerInfo;
import org.activemq.transport.stomp.CommandEnvelope;
import org.activemq.transport.stomp.DestinationNamer;
import org.activemq.transport.stomp.HeaderParser;
import org.activemq.transport.stomp.StompCommand;
import org.activemq.transport.stomp.StompWireFormat;
import org.activemq.transport.stomp.Subscription;

class Subscribe
implements StompCommand {
    private HeaderParser headerParser = new HeaderParser();
    private StompWireFormat format;

    Subscribe(StompWireFormat format) {
        this.format = format;
    }

    public CommandEnvelope build(String commandLine, DataInput in) throws IOException {
        ConsumerInfo ci = new ConsumerInfo();
        Properties headers = this.headerParser.parse(in);
        String destination = headers.getProperty("destination");
        ActiveMQDestination actual_dest = DestinationNamer.convert(destination);
        ci.setDestination(DestinationNamer.convert(destination));
        ConsumerId consumerId = this.format.createConsumerId();
        ci.setConsumerId(consumerId);
        ci.setResponseRequired(true);
        while (in.readByte() != 0) {
        }
        String subscriptionId = headers.getProperty("id", "~~ NO SUCH THING ~~%%@#!Q");
        Subscription s = new Subscription(this.format, consumerId, subscriptionId);
        s.setDestination(actual_dest);
        String ack_mode_key = headers.getProperty("ack");
        if (ack_mode_key != null && ack_mode_key.equals("client")) {
            s.setAckMode(2);
        }
        this.format.addSubscription(s);
        return new CommandEnvelope(ci, headers);
    }
}

