/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.stomp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.activemq.command.ActiveMQMessage;
import org.activemq.transport.stomp.DestinationNamer;

class FrameBuilder {
    private String command;
    private Properties headers = new Properties();
    private byte[] body = new byte[0];

    public FrameBuilder(String command) {
        this.command = command;
    }

    public FrameBuilder addHeader(String key, String value) {
        if (value != null) {
            this.headers.setProperty(key, value);
        }
        return this;
    }

    public FrameBuilder addHeader(String key, long value) {
        this.headers.put(key, new Long(value));
        return this;
    }

    public FrameBuilder addHeaders(ActiveMQMessage message) throws IOException {
        this.addHeader("destination", DestinationNamer.convert(message.getDestination()));
        this.addHeader("message-id", message.getJMSMessageID());
        this.addHeader("correlation-id", message.getJMSCorrelationID());
        this.addHeader("expires", message.getJMSExpiration());
        if (message.getJMSRedelivered()) {
            this.addHeader("redelivered", "true");
        }
        this.addHeader("priority", message.getJMSPriority());
        this.addHeader("reply-to", DestinationNamer.convert(message.getJMSReplyTo()));
        this.addHeader("timestamp", message.getJMSTimestamp());
        this.addHeader("type", message.getJMSType());
        Map properties = message.getProperties();
        if (properties != null) {
            this.headers.putAll((Map<?, ?>)properties);
        }
        return this;
    }

    public FrameBuilder setBody(byte[] body) {
        this.body = body;
        return this;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.command);
        buffer.append("\n");
        Iterator<Object> iterator = this.headers.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String property = this.headers.getProperty(key);
            if (property == null) continue;
            buffer.append(key).append(":").append(property).append("\n");
        }
        buffer.append("\n");
        buffer.append(this.body);
        buffer.append("\u0000");
        buffer.append("\n");
        return buffer.toString();
    }

    byte[] toFrame() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            bout.write(this.command.getBytes());
            bout.write("\n".getBytes());
            Iterator<Object> iterator = this.headers.keySet().iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                String property = this.headers.getProperty(key);
                if (property == null) continue;
                bout.write(key.getBytes());
                bout.write(":".getBytes());
                bout.write(property.getBytes());
                bout.write("\n".getBytes());
            }
            bout.write("\n".getBytes());
            bout.write(this.body);
            bout.write("\u0000".getBytes());
            bout.write("\n".getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException("World is caving in, we just got io error writing toa byte array output stream we instantiated!");
        }
        return bout.toByteArray();
    }
}

