/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.stomp;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.ProtocolException;
import javax.jms.JMSException;
import org.activemq.command.Command;
import org.activemq.command.Response;
import org.activemq.transport.stomp.Abort;
import org.activemq.transport.stomp.Ack;
import org.activemq.transport.stomp.Begin;
import org.activemq.transport.stomp.CommandEnvelope;
import org.activemq.transport.stomp.Commit;
import org.activemq.transport.stomp.Disconnect;
import org.activemq.transport.stomp.FrameBuilder;
import org.activemq.transport.stomp.ResponseListener;
import org.activemq.transport.stomp.Send;
import org.activemq.transport.stomp.StompCommand;
import org.activemq.transport.stomp.StompWireFormat;
import org.activemq.transport.stomp.Subscribe;
import org.activemq.transport.stomp.Unsubscribe;

class CommandParser {
    private String clientId;
    private final StompWireFormat format;

    CommandParser(StompWireFormat wireFormat) {
        this.format = wireFormat;
    }

    Command parse(DataInput in) throws IOException, JMSException {
        String line;
        try {
            while ((line = in.readLine()).trim().length() == 0) {
            }
        }
        catch (NullPointerException e) {
            throw new IOException("connection was closed");
        }
        StompCommand command = null;
        if (line.startsWith("SUB")) {
            command = new Subscribe(this.format);
        }
        if (line.startsWith("SEND")) {
            command = new Send(this.format);
        }
        if (line.startsWith("DISCONNECT")) {
            command = new Disconnect();
        }
        if (line.startsWith("BEGIN")) {
            command = new Begin(this.format);
        }
        if (line.startsWith("COMMIT")) {
            command = new Commit(this.format);
        }
        if (line.startsWith("ABORT")) {
            command = new Abort(this.format);
        }
        if (line.startsWith("UNSUB")) {
            command = new Unsubscribe(this.format);
        }
        if (line.startsWith("ACK")) {
            command = new Ack(this.format);
        }
        if (command == null) {
            while (in.readByte() == 0) {
            }
            throw new ProtocolException("Unknown command [" + line + "]");
        }
        CommandEnvelope envelope = command.build(line, in);
        if (envelope.getHeaders().containsKey("receipt")) {
            final short id = StompWireFormat.generateCommandId();
            envelope.getCommand().setCommandId(id);
            envelope.getCommand().setResponseRequired(true);
            final String client_packet_key = envelope.getHeaders().getProperty("receipt");
            this.format.addResponseListener(new ResponseListener(){

                public boolean onResponse(Response receipt, DataOutput out) throws IOException {
                    if (receipt.getCorrelationId() != id) {
                        return false;
                    }
                    out.write(new FrameBuilder("RECEIPT").addHeader("receipt-id", client_packet_key).toFrame());
                    return true;
                }
            });
        }
        return envelope.getCommand();
    }

    void setClientId(String clientId) {
        this.clientId = clientId;
    }
}

