/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.discovery.rendezvous;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import org.activemq.command.DiscoveryEvent;
import org.activemq.transport.discovery.DiscoveryAgent;
import org.activemq.transport.discovery.DiscoveryListener;
import org.activemq.transport.discovery.rendezvous.JmDNSFactory;
import org.activemq.util.JMSExceptionSupport;
import org.activemq.util.MapHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RendezvousDiscoveryAgent
implements DiscoveryAgent,
ServiceListener {
    private static final Log log = LogFactory.getLog((Class)RendezvousDiscoveryAgent.class);
    private static final String TYPE_SUFFIX = "ActiveMQ-4.";
    private JmDNS jmdns;
    private InetAddress localAddress;
    private String localhost;
    private int weight = 0;
    private int priority = 0;
    private DiscoveryListener listener;
    private String group = "default";
    private final CopyOnWriteArrayList serviceInfos = new CopyOnWriteArrayList();
    private String brokerName;

    public void start() throws Exception {
        if (this.group == null) {
            throw new IOException("You must specify a group to discover");
        }
        String type = this.getType();
        if (!type.endsWith(".")) {
            log.warn((Object)("The type '" + type + "' should end with '.' to be a valid Rendezvous type"));
            type = type + ".";
        }
        try {
            if (this.jmdns == null) {
                this.jmdns = this.createJmDNS();
            }
            if (this.listener != null) {
                log.info((Object)("Discovering service of type: " + type));
                this.jmdns.addServiceListener(type, (ServiceListener)this);
            }
        }
        catch (IOException e) {
            JMSExceptionSupport.create("Failed to start JmDNS service: " + e, e);
        }
    }

    public void stop() {
        if (this.jmdns != null) {
            Iterator iter = this.serviceInfos.iterator();
            while (iter.hasNext()) {
                ServiceInfo si = (ServiceInfo)iter.next();
                this.jmdns.unregisterService(si);
            }
            final JmDNS closeTarget = this.jmdns;
            Thread thread = new Thread(){

                public void run() {
                    closeTarget.close();
                }
            };
            thread.setDaemon(true);
            thread.start();
            this.jmdns = null;
        }
    }

    public void registerService(String name) throws IOException {
        if (this.jmdns == null) {
            throw new IllegalStateException("Not started.");
        }
        ServiceInfo si = this.createServiceInfo(name, new HashMap());
        this.serviceInfos.add((Object)si);
        this.jmdns.registerService(si);
    }

    public void addService(JmDNS jmDNS, String type, String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("addService with type: " + type + " name: " + name));
        }
        if (this.listener != null) {
            this.listener.onServiceAdd(new DiscoveryEvent(name));
        }
        jmDNS.requestServiceInfo(type, name);
    }

    public void removeService(JmDNS jmDNS, String type, String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeService with type: " + type + " name: " + name));
        }
        if (this.listener != null) {
            this.listener.onServiceRemove(new DiscoveryEvent(name));
        }
    }

    public void serviceAdded(ServiceEvent event) {
        this.addService(event.getDNS(), event.getType(), event.getName());
    }

    public void serviceRemoved(ServiceEvent event) {
        this.removeService(event.getDNS(), event.getType(), event.getName());
    }

    public void serviceResolved(ServiceEvent event) {
    }

    public void resolveService(JmDNS jmDNS, String type, String name, ServiceInfo serviceInfo) {
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public JmDNS getJmdns() {
        return this.jmdns;
    }

    public void setJmdns(JmDNS jmdns) {
        this.jmdns = jmdns;
    }

    public InetAddress getLocalAddress() throws UnknownHostException {
        if (this.localAddress == null) {
            this.localAddress = this.createLocalAddress();
        }
        return this.localAddress;
    }

    public void setLocalAddress(InetAddress localAddress) {
        this.localAddress = localAddress;
    }

    public String getLocalhost() {
        return this.localhost;
    }

    public void setLocalhost(String localhost) {
        this.localhost = localhost;
    }

    protected ServiceInfo createServiceInfo(String name, Map map) {
        int port = MapHelper.getInt(map, "port", 0);
        String type = this.getType();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering service type: " + type + " name: " + name + " details: " + map));
        }
        return new ServiceInfo(type, name + "." + type, port, this.weight, this.priority, "");
    }

    protected JmDNS createJmDNS() throws IOException {
        return JmDNSFactory.create(this.getLocalAddress());
    }

    protected InetAddress createLocalAddress() throws UnknownHostException {
        if (this.localhost != null) {
            return InetAddress.getByName(this.localhost);
        }
        return InetAddress.getLocalHost();
    }

    public void setDiscoveryListener(DiscoveryListener listener) {
        this.listener = listener;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getType() {
        return this.group + "." + TYPE_SUFFIX;
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }
}

