/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.discovery;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.activeio.FactoryFinder;
import org.activemq.transport.discovery.DiscoveryAgent;
import org.activemq.transport.discovery.simple.SimpleDiscoveryAgent;
import org.activemq.util.IOExceptionSupport;
import org.activemq.util.IntrospectionSupport;
import org.activemq.util.URISupport;

public abstract class DiscoveryAgentFactory {
    private static final FactoryFinder discoveryAgentFinder = new FactoryFinder("META-INF/services/org/activemq/transport/discoveryagent/");

    public static DiscoveryAgent createDiscoveryAgent(String type) throws IOException {
        try {
            return (DiscoveryAgent)discoveryAgentFinder.newInstance(type);
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create("Could not create discovery agent: " + type, e);
        }
    }

    public static DiscoveryAgent createDiscoveryAgent(URI uri) throws IOException {
        try {
            String type = uri.getScheme() == null ? uri.getPath() : uri.getScheme();
            DiscoveryAgent rc = (DiscoveryAgent)discoveryAgentFinder.newInstance(type);
            Map options = URISupport.parseParamters(uri);
            IntrospectionSupport.setProperties(rc, options);
            if (rc.getClass() == SimpleDiscoveryAgent.class) {
                URISupport.CompositeData data = URISupport.parseComposite(uri);
                ((SimpleDiscoveryAgent)rc).setServices(data.getComponents());
            }
            return rc;
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create("Could not create discovery agent: " + uri, e);
        }
    }
}

