/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.activeio;

import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.activeio.AsyncChannel;
import org.activeio.Channel;
import org.activeio.ChannelFactory;
import org.activeio.adapter.SyncToAsyncChannel;
import org.activeio.command.AsyncChannelToAsyncCommandChannel;
import org.activeio.command.AsyncCommandChannel;
import org.activeio.command.WireFormat;
import org.activeio.net.SocketMetadata;
import org.activemq.transport.InactivityMonitor;
import org.activemq.transport.MutexTransport;
import org.activemq.transport.ResponseCorrelator;
import org.activemq.transport.Transport;
import org.activemq.transport.TransportFactory;
import org.activemq.transport.TransportLogger;
import org.activemq.transport.TransportServer;
import org.activemq.transport.WireFormatNegotiator;
import org.activemq.transport.activeio.ActiveIOTransport;
import org.activemq.transport.activeio.ActiveIOTransportServer;
import org.activemq.transport.activeio.ActivityMonitor;
import org.activemq.transport.activeio.PacketAggregatingAsyncChannel;
import org.activemq.util.IOExceptionSupport;
import org.activemq.util.IntrospectionSupport;
import org.activemq.util.URISupport;

public class ActiveIOTransportFactory
extends TransportFactory {
    private static final HashMap toSchemeMap = new HashMap();
    private static final HashMap fromSchemeMap = new HashMap();

    public Transport doConnect(URI location) throws IOException {
        try {
            HashMap options = new HashMap(URISupport.parseParamters(location));
            location = ActiveIOTransportFactory.convertToActiveIOURI(location);
            Transport rc = ActiveIOTransportFactory.connect(location, this.createWireFormat(options), options);
            if (!options.isEmpty()) {
                throw new IllegalArgumentException("Invalid connect parameters: " + options);
            }
            return rc;
        }
        catch (URISyntaxException e) {
            throw IOExceptionSupport.create(e);
        }
    }

    public Transport doConnect(URI location, Executor ex) throws IOException {
        try {
            HashMap options = new HashMap(URISupport.parseParamters(location));
            location = ActiveIOTransportFactory.convertToActiveIOURI(location);
            Transport rc = ActiveIOTransportFactory.connect(location, this.createWireFormat(options), options, ex);
            if (!options.isEmpty()) {
                throw new IllegalArgumentException("Invalid connect parameters: " + options);
            }
            return rc;
        }
        catch (URISyntaxException e) {
            throw IOExceptionSupport.create(e);
        }
    }

    public Transport doCompositeConnect(URI location) throws IOException {
        try {
            Map options = URISupport.parseParamters(location);
            location = ActiveIOTransportFactory.convertToActiveIOURI(location);
            Transport rc = ActiveIOTransportFactory.compositeConnect(location, this.createWireFormat(options), options);
            if (!options.isEmpty()) {
                throw new IllegalArgumentException("Invalid connect parameters: " + options);
            }
            return rc;
        }
        catch (URISyntaxException e) {
            throw IOExceptionSupport.create(e);
        }
    }

    public Transport doCompositeConnect(URI location, Executor ex) throws IOException {
        try {
            Map options = URISupport.parseParamters(location);
            location = ActiveIOTransportFactory.convertToActiveIOURI(location);
            Transport rc = ActiveIOTransportFactory.compositeConnect(location, this.createWireFormat(options), options, ex);
            if (!options.isEmpty()) {
                throw new IllegalArgumentException("Invalid connect parameters: " + options);
            }
            return rc;
        }
        catch (URISyntaxException e) {
            throw IOExceptionSupport.create(e);
        }
    }

    public TransportServer doBind(String brokerId, final URI location) throws IOException {
        try {
            HashMap options = new HashMap(URISupport.parseParamters(location));
            ActiveIOTransportServer server = new ActiveIOTransportServer(ActiveIOTransportFactory.convertToActiveIOURI(location), options){

                public URI getBindURI() {
                    return location;
                }

                public URI getConnectURI() {
                    return ActiveIOTransportFactory.convertFromActiveIOURI(super.getConnectURI());
                }
            };
            server.setWireFormatFactory(this.createWireFormatFactory(options));
            IntrospectionSupport.setProperties(server, options);
            return server;
        }
        catch (URISyntaxException e) {
            throw IOExceptionSupport.create(e);
        }
    }

    static URI convertToActiveIOURI(URI location) {
        try {
            String scheme = location.getScheme();
            String target = (String)toSchemeMap.get(scheme);
            if (target != null) {
                return new URI(target, location.getSchemeSpecificPart(), location.getFragment());
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return location;
    }

    static URI convertFromActiveIOURI(URI location) {
        try {
            String scheme = location.getScheme();
            String target = (String)fromSchemeMap.get(scheme);
            if (target != null) {
                return new URI(target, location.getSchemeSpecificPart(), location.getFragment());
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return location;
    }

    public static Transport connect(URI location, WireFormat format, Map options) throws IOException {
        return ActiveIOTransportFactory.configure(new ChannelFactory().openAsyncChannel(location), format, options);
    }

    public static Transport connect(URI location, WireFormat format, Map options, Executor ex) throws IOException {
        return ActiveIOTransportFactory.configure((Channel)new ChannelFactory().openAsyncChannel(location), format, options, ex);
    }

    public static Transport configure(Channel c, WireFormat format, Map options) {
        AsyncChannel channel = SyncToAsyncChannel.adapt((Channel)c);
        return ActiveIOTransportFactory.configure(channel, format, options);
    }

    public static Transport configure(Channel c, WireFormat format, Map options, Executor ex) {
        AsyncChannel channel = SyncToAsyncChannel.adapt((Channel)c, (Executor)ex);
        return ActiveIOTransportFactory.configure(channel, format, options);
    }

    public static Transport configure(AsyncChannel channel, WireFormat format, Map options) {
        ActivityMonitor activityMonitor = new ActivityMonitor((AsyncChannel)channel);
        AsyncChannelToAsyncCommandChannel commandChannel = new AsyncChannelToAsyncCommandChannel(channel = new PacketAggregatingAsyncChannel((AsyncChannel)activityMonitor), format);
        SocketMetadata socketMetadata = (SocketMetadata)commandChannel.getAdapter(SocketMetadata.class);
        if (socketMetadata != null) {
            IntrospectionSupport.setProperties(socketMetadata, options);
        }
        ActiveIOTransport activeIOTransport = new ActiveIOTransport((AsyncCommandChannel)commandChannel);
        IntrospectionSupport.setProperties(activeIOTransport, options);
        activeIOTransport.setReadCounter(activityMonitor.getReadCounter());
        activeIOTransport.setWriteCounter(activityMonitor.getWriteCounter());
        Transport transport = activeIOTransport;
        if (activeIOTransport.isTrace()) {
            transport = new TransportLogger(transport);
        }
        transport = new InactivityMonitor(transport, activeIOTransport.getMaxInactivityDuration(), activityMonitor.getReadCounter(), activityMonitor.getWriteCounter());
        transport = new WireFormatNegotiator(transport, format, activeIOTransport.getMinmumWireFormatVersion());
        transport = new MutexTransport(transport);
        transport = new ResponseCorrelator(transport);
        return transport;
    }

    public static Transport compositeConnect(URI location, WireFormat format, Map options) throws IOException {
        return ActiveIOTransportFactory.compositeConfigure(new ChannelFactory().openAsyncChannel(location), format, options);
    }

    public static Transport compositeConnect(URI location, WireFormat format, Map options, Executor ex) throws IOException {
        return ActiveIOTransportFactory.compositeConfigure((Channel)new ChannelFactory().openAsyncChannel(location), format, options, ex);
    }

    public static Transport compositeConfigure(Channel c, WireFormat format, Map options) {
        AsyncChannel channel = SyncToAsyncChannel.adapt((Channel)c);
        return ActiveIOTransportFactory.compositeConfigure(channel, format, options);
    }

    public static Transport compositeConfigure(Channel c, WireFormat format, Map options, Executor ex) {
        AsyncChannel channel = SyncToAsyncChannel.adapt((Channel)c, (Executor)ex);
        return ActiveIOTransportFactory.compositeConfigure(channel, format, options);
    }

    public static Transport compositeConfigure(AsyncChannel channel, WireFormat format, Map options) {
        ActivityMonitor activityMonitor = new ActivityMonitor((AsyncChannel)channel);
        AsyncChannelToAsyncCommandChannel commandChannel = new AsyncChannelToAsyncCommandChannel(channel = new PacketAggregatingAsyncChannel((AsyncChannel)activityMonitor), format);
        SocketMetadata socketMetadata = (SocketMetadata)commandChannel.getAdapter(SocketMetadata.class);
        if (socketMetadata != null) {
            IntrospectionSupport.setProperties(socketMetadata, options, "socket.");
        }
        ActiveIOTransport activeIOTransport = new ActiveIOTransport((AsyncCommandChannel)commandChannel);
        IntrospectionSupport.setProperties(activeIOTransport, options);
        activeIOTransport.setReadCounter(activityMonitor.getReadCounter());
        activeIOTransport.setWriteCounter(activityMonitor.getWriteCounter());
        Transport transport = activeIOTransport;
        if (activeIOTransport.isTrace()) {
            transport = new TransportLogger(transport);
        }
        transport = new InactivityMonitor(transport, activeIOTransport.getMaxInactivityDuration(), activityMonitor.getReadCounter(), activityMonitor.getWriteCounter());
        transport = new WireFormatNegotiator(transport, format, activeIOTransport.getMinmumWireFormatVersion());
        return transport;
    }

    static {
        toSchemeMap.put("tcp", "socket");
        fromSchemeMap.put("socket", "tcp");
        toSchemeMap.put("nio", "nio-async");
        fromSchemeMap.put("nio-async", "nio");
        toSchemeMap.put("aio", "aio");
        fromSchemeMap.put("aio", "aio");
        toSchemeMap.put("ssl", "ssl");
        fromSchemeMap.put("ssl", "ssl");
        toSchemeMap.put("vmpipe", "vmpipe");
        fromSchemeMap.put("vmpipe", "vmpipe");
        toSchemeMap.put("jxta", "jxta");
        fromSchemeMap.put("jxta", "jxta");
    }
}

