/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.activeio;

import java.io.IOException;
import java.net.SocketException;
import org.activeio.command.AsyncCommandChannel;
import org.activeio.command.CommandListener;
import org.activeio.net.SocketMetadata;
import org.activemq.command.Command;
import org.activemq.command.Response;
import org.activemq.command.WireFormatInfo;
import org.activemq.management.CountStatisticImpl;
import org.activemq.transport.FutureResponse;
import org.activemq.transport.Transport;
import org.activemq.transport.TransportListener;

public class ActiveIOTransport
implements Transport {
    private AsyncCommandChannel commandChannel;
    private TransportListener transportListener;
    private long timeout = 2000L;
    private int minmumWireFormatVersion = 0;
    private long maxInactivityDuration = 60000L;
    private boolean trace = false;
    private long stopTimeout = 2000L;
    private CountStatisticImpl readCounter;
    private CountStatisticImpl writeCounter;

    public ActiveIOTransport(AsyncCommandChannel commandChannel) {
        this.commandChannel = commandChannel;
        this.commandChannel.setCommandListener(new CommandListener(){

            public void onCommand(Object command) {
                WireFormatInfo info;
                if (command.getClass() == (class$org$activemq$command$WireFormatInfo == null ? (class$org$activemq$command$WireFormatInfo = ActiveIOTransport.class$("org.activemq.command.WireFormatInfo")) : class$org$activemq$command$WireFormatInfo) && (info = (WireFormatInfo)command).isTcpNoDelayEnabled()) {
                    try {
                        ActiveIOTransport.this.enableTcpNodeDelay();
                    }
                    catch (SocketException e) {
                        this.onError(e);
                    }
                }
                ActiveIOTransport.this.transportListener.onCommand((Command)command);
            }

            public void onError(Exception e) {
                if (e instanceof IOException) {
                    ActiveIOTransport.this.transportListener.onException((IOException)e);
                } else {
                    ActiveIOTransport.this.transportListener.onException((IOException)new IOException().initCause(e));
                }
            }
        });
    }

    private void enableTcpNodeDelay() throws SocketException {
        SocketMetadata sm = (SocketMetadata)this.commandChannel.getAdapter(SocketMetadata.class);
        if (sm != null) {
            sm.setTcpNoDelay(true);
        }
    }

    public void oneway(Command command) throws IOException {
        WireFormatInfo info;
        if (command.getClass() == WireFormatInfo.class && (info = (WireFormatInfo)command).isTcpNoDelayEnabled()) {
            this.enableTcpNodeDelay();
        }
        this.commandChannel.writeCommand((Object)command);
    }

    public FutureResponse asyncRequest(Command command) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    public Response request(Command command) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    public void start() throws Exception {
        this.commandChannel.start();
    }

    public void stop() throws Exception {
        this.commandChannel.stop(this.stopTimeout);
        this.commandChannel.dispose();
    }

    public TransportListener getTransportListener() {
        return this.transportListener;
    }

    public void setTransportListener(TransportListener listener) {
        this.transportListener = listener;
    }

    public AsyncCommandChannel getCommandChannel() {
        return this.commandChannel;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public Object narrow(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    public int getMinmumWireFormatVersion() {
        return this.minmumWireFormatVersion;
    }

    public void setMinmumWireFormatVersion(int minmumWireFormatVersion) {
        this.minmumWireFormatVersion = minmumWireFormatVersion;
    }

    public long getMaxInactivityDuration() {
        return this.maxInactivityDuration;
    }

    public void setMaxInactivityDuration(long maxInactivityDuration) {
        this.maxInactivityDuration = maxInactivityDuration;
    }

    public long getStopTimeout() {
        return this.stopTimeout;
    }

    public void setStopTimeout(long stopTimeout) {
        this.stopTimeout = stopTimeout;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public void setReadCounter(CountStatisticImpl readCounter) {
        this.readCounter = readCounter;
    }

    public void setWriteCounter(CountStatisticImpl writeCounter) {
        this.writeCounter = writeCounter;
    }

    public CountStatisticImpl getReadCounter() {
        return this.readCounter;
    }

    public CountStatisticImpl getWriteCounter() {
        return this.writeCounter;
    }
}

