/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import org.activemq.transport.TransportSupport;
import org.activemq.util.ServiceStopper;

public abstract class TransportThreadSupport
extends TransportSupport
implements Runnable {
    private AtomicBoolean closed = new AtomicBoolean(false);
    private AtomicBoolean started = new AtomicBoolean(false);
    private boolean daemon = false;
    private Thread runner;

    public void start() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            this.runner = new Thread((Runnable)this, this.toString());
            this.runner.setDaemon(this.daemon);
            this.runner.start();
        }
    }

    public void stop() throws Exception {
        if (this.closed.compareAndSet(false, true)) {
            this.started.set(false);
            ServiceStopper stopper = new ServiceStopper();
            try {
                this.doStop(stopper);
            }
            catch (Exception e) {
                stopper.onException(this, e);
            }
            stopper.throwFirstException();
        }
        this.closed.set(true);
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    protected abstract void doStop(ServiceStopper var1) throws Exception;
}

