/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport;

import java.io.IOException;
import org.activemq.command.Command;
import org.activemq.command.Response;
import org.activemq.transport.FutureResponse;
import org.activemq.transport.Transport;
import org.activemq.transport.TransportListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class TransportSupport
implements Transport {
    private static final Log log = LogFactory.getLog((Class)TransportSupport.class);
    private TransportListener transportListener;

    public TransportListener getTransportListener() {
        return this.transportListener;
    }

    public void setTransportListener(TransportListener commandListener) {
        this.transportListener = commandListener;
    }

    public Object narrow(Class target) {
        boolean assignableFrom = target.isAssignableFrom(this.getClass());
        if (assignableFrom) {
            return this;
        }
        return null;
    }

    public FutureResponse asyncRequest(Command command) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    public Response request(Command command) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    public void doConsume(Command command) {
        if (command != null) {
            if (this.transportListener != null) {
                this.transportListener.onCommand(command);
            } else {
                log.error((Object)("No transportListener available to process inbound command: " + command));
            }
        }
    }

    public void onException(IOException e) {
        if (this.transportListener != null) {
            this.transportListener.onException(e);
        }
    }
}

