/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.net.URI;
import org.activemq.transport.TransportServerSupport;
import org.activemq.util.ServiceStopper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class TransportServerThreadSupport
extends TransportServerSupport
implements Runnable {
    private static final Log log = LogFactory.getLog((Class)TransportServerThreadSupport.class);
    private AtomicBoolean closed = new AtomicBoolean(false);
    private AtomicBoolean started = new AtomicBoolean(false);
    private AtomicBoolean closing = new AtomicBoolean(false);
    private boolean daemon = true;
    private Thread runner;

    public TransportServerThreadSupport() {
    }

    public TransportServerThreadSupport(URI location) {
        super(location);
    }

    public void start() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            log.info((Object)("Listening for connections at: " + this.getLocation()));
            this.runner = new Thread((Runnable)this, this.toString());
            this.runner.setDaemon(this.daemon);
            this.runner.setPriority(9);
            this.runner.start();
        }
    }

    public void stop() throws Exception {
        if (this.closed.compareAndSet(false, true)) {
            this.closing.set(true);
            ServiceStopper stopper = new ServiceStopper();
            try {
                this.doStop(stopper);
            }
            catch (Exception e) {
                stopper.onException(this, e);
            }
            if (this.runner != null) {
                this.runner.join();
                this.runner = null;
            }
            this.closed.set(true);
            this.started.set(false);
            this.closing.set(false);
            stopper.throwFirstException();
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isClosing() {
        return this.closing.get();
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    protected abstract void doStop(ServiceStopper var1) throws Exception;
}

