/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.store.memory;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.activemq.broker.ConnectionContext;
import org.activemq.command.ActiveMQQueue;
import org.activemq.command.ActiveMQTopic;
import org.activemq.store.MessageStore;
import org.activemq.store.PersistenceAdapter;
import org.activemq.store.TopicMessageStore;
import org.activemq.store.TransactionStore;
import org.activemq.store.memory.MemoryMessageStore;
import org.activemq.store.memory.MemoryTopicMessageStore;
import org.activemq.store.memory.MemoryTransactionStore;

public class MemoryPersistenceAdapter
implements PersistenceAdapter {
    MemoryTransactionStore transactionStore;
    ConcurrentHashMap topics = new ConcurrentHashMap();
    ConcurrentHashMap queues = new ConcurrentHashMap();
    private boolean useExternalMessageReferences;

    public Set getDestinations() {
        HashSet rc = new HashSet(this.queues.size() + this.topics.size());
        Iterator iter = this.queues.keySet().iterator();
        while (iter.hasNext()) {
            rc.add(iter.next());
        }
        iter = this.topics.keySet().iterator();
        while (iter.hasNext()) {
            rc.add(iter.next());
        }
        return rc;
    }

    public static MemoryPersistenceAdapter newInstance(File file) {
        return new MemoryPersistenceAdapter();
    }

    public MessageStore createQueueMessageStore(ActiveMQQueue destination) throws IOException {
        MessageStore rc = (MessageStore)this.queues.get((Object)destination);
        if (rc == null) {
            rc = new MemoryMessageStore(destination);
            if (this.transactionStore != null) {
                rc = this.transactionStore.proxy(rc);
            }
            this.queues.put((Object)destination, (Object)rc);
        }
        return rc;
    }

    public TopicMessageStore createTopicMessageStore(ActiveMQTopic destination) throws IOException {
        TopicMessageStore rc = (TopicMessageStore)this.topics.get((Object)destination);
        if (rc == null) {
            rc = new MemoryTopicMessageStore(destination);
            if (this.transactionStore != null) {
                rc = this.transactionStore.proxy(rc);
            }
            this.topics.put((Object)destination, (Object)rc);
        }
        return rc;
    }

    public TransactionStore createTransactionStore() throws IOException {
        if (this.transactionStore == null) {
            this.transactionStore = new MemoryTransactionStore();
        }
        return this.transactionStore;
    }

    public void beginTransaction(ConnectionContext context) {
    }

    public void commitTransaction(ConnectionContext context) {
    }

    public void rollbackTransaction(ConnectionContext context) {
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public long getLastMessageBrokerSequenceId() throws IOException {
        return 0L;
    }

    public void deleteAllMessages() throws IOException {
        MemoryMessageStore store;
        Iterator iter = this.topics.values().iterator();
        while (iter.hasNext()) {
            store = (MemoryMessageStore)iter.next();
            store.delete();
        }
        iter = this.queues.values().iterator();
        while (iter.hasNext()) {
            store = (MemoryMessageStore)iter.next();
            store.delete();
        }
        this.transactionStore.delete();
    }

    public boolean isUseExternalMessageReferences() {
        return this.useExternalMessageReferences;
    }

    public void setUseExternalMessageReferences(boolean useExternalMessageReferences) {
        this.useExternalMessageReferences = useExternalMessageReferences;
    }
}

