/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.store.memory;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.activemq.broker.ConnectionContext;
import org.activemq.command.ActiveMQDestination;
import org.activemq.command.Message;
import org.activemq.command.MessageAck;
import org.activemq.command.MessageId;
import org.activemq.store.MessageRecoveryListener;
import org.activemq.store.MessageStore;

public class MemoryMessageStore
implements MessageStore {
    protected final ActiveMQDestination destination;
    protected final Map messageTable;
    static /* synthetic */ Class class$java$lang$String;

    public MemoryMessageStore(ActiveMQDestination destination) {
        this(destination, new LinkedHashMap());
    }

    public MemoryMessageStore(ActiveMQDestination destination, Map messageTable) {
        this.destination = destination;
        this.messageTable = Collections.synchronizedMap(messageTable);
    }

    public synchronized void addMessage(ConnectionContext context, Message message) throws IOException {
        this.messageTable.put(message.getMessageId(), message);
    }

    public void addMessageReference(ConnectionContext context, MessageId messageId, long expirationTime, String messageRef) throws IOException {
        this.messageTable.put(messageId, messageRef);
    }

    public Message getMessage(MessageId identity) throws IOException {
        return (Message)this.messageTable.get(identity);
    }

    public String getMessageReference(MessageId identity) throws IOException {
        return (String)this.messageTable.get(identity);
    }

    public void removeMessage(ConnectionContext context, MessageAck ack) throws IOException {
        this.messageTable.remove(ack.getLastMessageId());
    }

    public void removeMessage(MessageId msgId) throws IOException {
        this.messageTable.remove(msgId);
    }

    public void recover(MessageRecoveryListener listener) throws Throwable {
        Iterator iter = this.messageTable.values().iterator();
        while (iter.hasNext()) {
            Object msg = iter.next();
            if (msg.getClass() == (class$java$lang$String == null ? MemoryMessageStore.class$("java.lang.String") : class$java$lang$String)) {
                listener.recoverMessageReference((String)msg);
                continue;
            }
            listener.recoverMessage((Message)msg);
        }
    }

    public void start() throws IOException {
    }

    public void stop(long timeout) throws IOException {
    }

    public void removeAllMessages(ConnectionContext context) throws IOException {
        this.messageTable.clear();
    }

    public ActiveMQDestination getDestination() {
        return this.destination;
    }

    public void delete() {
        this.messageTable.clear();
    }
}

