/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.state;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.io.IOException;
import java.util.Iterator;
import org.activemq.command.BrokerInfo;
import org.activemq.command.Command;
import org.activemq.command.ConnectionId;
import org.activemq.command.ConnectionInfo;
import org.activemq.command.ConsumerId;
import org.activemq.command.ConsumerInfo;
import org.activemq.command.DestinationInfo;
import org.activemq.command.FlushCommand;
import org.activemq.command.KeepAliveInfo;
import org.activemq.command.Message;
import org.activemq.command.MessageAck;
import org.activemq.command.ProducerId;
import org.activemq.command.ProducerInfo;
import org.activemq.command.RemoveSubscriptionInfo;
import org.activemq.command.Response;
import org.activemq.command.SessionId;
import org.activemq.command.SessionInfo;
import org.activemq.command.ShutdownInfo;
import org.activemq.command.TransactionInfo;
import org.activemq.command.WireFormatInfo;
import org.activemq.state.CommandVisitor;
import org.activemq.state.ConnectionState;
import org.activemq.state.ConsumerState;
import org.activemq.state.ProducerState;
import org.activemq.state.SessionState;
import org.activemq.transport.Transport;
import org.activemq.util.IOExceptionSupport;

public class ConnectionStateTracker
implements CommandVisitor {
    private static final Response TRACKED_RESPONSE_MARKER = new Response();
    boolean trackTransactions = false;
    boolean trackMessages = false;
    boolean trackAcks = false;
    private boolean restoreSessions = true;
    boolean restoreConsumers = true;
    private boolean restoreProducers = true;
    protected final ConcurrentHashMap connectionStates = new ConcurrentHashMap();

    public boolean track(Command command) throws IOException {
        try {
            return command.visit(this) != null;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create(e);
        }
    }

    public void restore(Transport transport) throws IOException {
        Iterator iter = this.connectionStates.values().iterator();
        while (iter.hasNext()) {
            ConnectionState connectionState = (ConnectionState)iter.next();
            transport.oneway(connectionState.getInfo());
            this.restoreTempDestinations(transport, connectionState);
            if (!this.restoreSessions) continue;
            this.restoreSessions(transport, connectionState);
        }
    }

    protected void restoreSessions(Transport transport, ConnectionState connectionState) throws IOException {
        Iterator iter2 = connectionState.getSessionStates().iterator();
        while (iter2.hasNext()) {
            SessionState sessionState = (SessionState)iter2.next();
            transport.oneway(sessionState.getInfo());
            if (this.restoreProducers) {
                this.restoreProducers(transport, sessionState);
            }
            if (!this.restoreConsumers) continue;
            this.restoreConsumers(transport, sessionState);
        }
    }

    protected void restoreConsumers(Transport transport, SessionState sessionState) throws IOException {
        Iterator iter3 = sessionState.getConsumerStates().iterator();
        while (iter3.hasNext()) {
            ConsumerState consumerState = (ConsumerState)iter3.next();
            transport.oneway(consumerState.getInfo());
        }
    }

    protected void restoreProducers(Transport transport, SessionState sessionState) throws IOException {
        Iterator iter3 = sessionState.getProducerStates().iterator();
        while (iter3.hasNext()) {
            ProducerState producerState = (ProducerState)iter3.next();
            transport.oneway(producerState.getInfo());
        }
    }

    protected void restoreTempDestinations(Transport transport, ConnectionState connectionState) throws IOException {
        Iterator iter2 = connectionState.getTempDesinations().iterator();
        while (iter2.hasNext()) {
            transport.oneway((DestinationInfo)iter2.next());
        }
    }

    public Response processAddDestination(DestinationInfo info) throws Throwable {
        ConnectionState cs = (ConnectionState)this.connectionStates.get((Object)info.getConnectionId());
        if (info.getDestination().isTemporary()) {
            cs.addTempDestination(info.getDestination());
        }
        return TRACKED_RESPONSE_MARKER;
    }

    public Response processRemoveDestination(DestinationInfo info) throws Throwable {
        ConnectionState cs = (ConnectionState)this.connectionStates.get((Object)info.getConnectionId());
        if (info.getDestination().isTemporary()) {
            cs.removeTempDestination(info.getDestination());
        }
        return TRACKED_RESPONSE_MARKER;
    }

    public Response processAddProducer(ProducerInfo info) throws Throwable {
        SessionId sessionId = info.getProducerId().getParentId();
        ConnectionId connectionId = sessionId.getParentId();
        ConnectionState cs = (ConnectionState)this.connectionStates.get((Object)connectionId);
        SessionState ss = cs.getSessionState(sessionId);
        ss.addProducer(info);
        return TRACKED_RESPONSE_MARKER;
    }

    public Response processRemoveProducer(ProducerId id) throws Throwable {
        SessionId sessionId = id.getParentId();
        ConnectionId connectionId = sessionId.getParentId();
        ConnectionState cs = (ConnectionState)this.connectionStates.get((Object)connectionId);
        SessionState ss = cs.getSessionState(sessionId);
        ss.removeProducer(id);
        return TRACKED_RESPONSE_MARKER;
    }

    public Response processAddConsumer(ConsumerInfo info) throws Throwable {
        SessionId sessionId = info.getConsumerId().getParentId();
        ConnectionId connectionId = sessionId.getParentId();
        ConnectionState cs = (ConnectionState)this.connectionStates.get((Object)connectionId);
        SessionState ss = cs.getSessionState(sessionId);
        ss.addConsumer(info);
        return TRACKED_RESPONSE_MARKER;
    }

    public Response processRemoveConsumer(ConsumerId id) throws Throwable {
        SessionId sessionId = id.getParentId();
        ConnectionId connectionId = sessionId.getParentId();
        ConnectionState cs = (ConnectionState)this.connectionStates.get((Object)connectionId);
        SessionState ss = cs.getSessionState(sessionId);
        ss.removeConsumer(id);
        return TRACKED_RESPONSE_MARKER;
    }

    public Response processAddSession(SessionInfo info) throws Throwable {
        ConnectionId connectionId = info.getSessionId().getParentId();
        ConnectionState cs = (ConnectionState)this.connectionStates.get((Object)connectionId);
        cs.addSession(info);
        return TRACKED_RESPONSE_MARKER;
    }

    public Response processRemoveSession(SessionId id) throws Throwable {
        ConnectionId connectionId = id.getParentId();
        ConnectionState cs = (ConnectionState)this.connectionStates.get((Object)connectionId);
        cs.removeSession(id);
        return TRACKED_RESPONSE_MARKER;
    }

    public Response processAddConnection(ConnectionInfo info) throws Throwable {
        this.connectionStates.put((Object)info.getConnectionId(), (Object)new ConnectionState(info));
        return TRACKED_RESPONSE_MARKER;
    }

    public Response processRemoveConnection(ConnectionId id) throws Throwable {
        this.connectionStates.remove((Object)id);
        return TRACKED_RESPONSE_MARKER;
    }

    public Response processRemoveSubscription(RemoveSubscriptionInfo info) throws Throwable {
        return null;
    }

    public Response processMessage(Message send) throws Throwable {
        return null;
    }

    public Response processMessageAck(MessageAck ack) throws Throwable {
        return null;
    }

    public Response processBeginTransaction(TransactionInfo info) throws Throwable {
        return null;
    }

    public Response processPrepareTransaction(TransactionInfo info) throws Throwable {
        return null;
    }

    public Response processCommitTransactionOnePhase(TransactionInfo info) throws Throwable {
        return null;
    }

    public Response processCommitTransactionTwoPhase(TransactionInfo info) throws Throwable {
        return null;
    }

    public Response processRollbackTransaction(TransactionInfo info) throws Throwable {
        return null;
    }

    public Response processWireFormat(WireFormatInfo info) throws Throwable {
        return null;
    }

    public Response processKeepAlive(KeepAliveInfo info) throws Throwable {
        return null;
    }

    public Response processShutdown(ShutdownInfo info) throws Throwable {
        return null;
    }

    public Response processBrokerInfo(BrokerInfo info) throws Throwable {
        return null;
    }

    public Response processRecoverTransactions(TransactionInfo info) {
        return null;
    }

    public Response processForgetTransaction(TransactionInfo info) throws Throwable {
        return null;
    }

    public Response processEndTransaction(TransactionInfo info) throws Throwable {
        return null;
    }

    public Response processFlush(FlushCommand command) throws Throwable {
        return null;
    }

    public boolean isRestoreConsumers() {
        return this.restoreConsumers;
    }

    public void setRestoreConsumers(boolean restoreConsumers) {
        this.restoreConsumers = restoreConsumers;
    }

    public boolean isRestoreProducers() {
        return this.restoreProducers;
    }

    public void setRestoreProducers(boolean restoreProducers) {
        this.restoreProducers = restoreProducers;
    }

    public boolean isRestoreSessions() {
        return this.restoreSessions;
    }

    public void setRestoreSessions(boolean restoreSessions) {
        this.restoreSessions = restoreSessions;
    }
}

