/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.security;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.activemq.broker.Broker;
import org.activemq.broker.BrokerFilter;
import org.activemq.broker.ConnectionContext;
import org.activemq.command.ConnectionInfo;
import org.activemq.security.SecurityContext;

public class SimpleAuthenticationBroker
extends BrokerFilter {
    private final Map userPasswords;
    private final Map userGroups;
    private final CopyOnWriteArrayList securityContexts = new CopyOnWriteArrayList();

    public SimpleAuthenticationBroker(Broker next, Map userPasswords, Map userGroups) {
        super(next);
        this.userPasswords = userPasswords;
        this.userGroups = userGroups;
    }

    public void addConnection(ConnectionContext context, ConnectionInfo info) throws Throwable {
        if (context.getSecurityContext() == null) {
            String pw = (String)this.userPasswords.get(info.getUserName());
            if (pw == null || !pw.equals(info.getPassword())) {
                throw new SecurityException("User name or password is invalid.");
            }
            final Set groups = (Set)this.userGroups.get(info.getUserName());
            SecurityContext s = new SecurityContext(info.getUserName()){

                public Set getPrincipals() {
                    return groups;
                }
            };
            context.setSecurityContext(s);
            this.securityContexts.add((Object)s);
        }
        super.addConnection(context, info);
    }

    public void removeConnection(ConnectionContext context, ConnectionInfo info, Throwable error) throws Throwable {
        super.removeConnection(context, info, error);
        if (this.securityContexts.remove((Object)context.getSecurityContext())) {
            context.setSecurityContext(null);
        }
    }

    public void refresh() {
        Iterator iter = this.securityContexts.iterator();
        while (iter.hasNext()) {
            SecurityContext sc = (SecurityContext)iter.next();
            sc.getAuthorizedReadDests().clear();
            sc.getAuthorizedWriteDests().clear();
        }
    }
}

