/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.proxy;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.activemq.Service;
import org.activemq.proxy.ProxyConnection;
import org.activemq.transport.CompositeTransport;
import org.activemq.transport.Transport;
import org.activemq.transport.TransportAcceptListener;
import org.activemq.transport.TransportFactory;
import org.activemq.transport.TransportServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProxyConnector
implements Service {
    private static final Log log = LogFactory.getLog((Class)ProxyConnector.class);
    private TransportServer server;
    private URI bind;
    private URI remote;
    private URI localUri;

    public void start() throws Exception {
        this.getServer().setAcceptListener(new TransportAcceptListener(){

            public void onAccept(Transport localTransport) {
                try {
                    Transport remoteTransport = ProxyConnector.this.createRemoteTransport();
                    ProxyConnection connection = new ProxyConnection(localTransport, remoteTransport);
                    connection.start();
                }
                catch (Exception e) {
                    this.onAcceptError(e);
                }
            }

            public void onAcceptError(Exception error) {
                log.error((Object)("Could not accept connection: " + error), (Throwable)error);
            }
        });
        this.getServer().start();
    }

    public void stop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public URI getLocalUri() throws URISyntaxException {
        return this.localUri;
    }

    public void setLocalUri(URI localURI) {
        this.localUri = localURI;
    }

    public URI getBind() {
        return this.bind;
    }

    public void setBind(URI bind) {
        this.bind = bind;
    }

    public URI getRemote() {
        return this.remote;
    }

    public void setRemote(URI remote) {
        this.remote = remote;
    }

    public TransportServer getServer() throws IOException, URISyntaxException {
        if (this.server == null) {
            this.server = this.createServer();
        }
        return this.server;
    }

    public void setServer(TransportServer server) {
        this.server = server;
    }

    protected TransportServer createServer() throws IOException, URISyntaxException {
        if (this.bind == null) {
            throw new IllegalArgumentException("You must specify either a server or the bind property");
        }
        return TransportFactory.bind(null, this.bind);
    }

    private Transport createRemoteTransport() throws Exception {
        Transport transport = TransportFactory.compositeConnect(this.remote);
        CompositeTransport ct = (CompositeTransport)transport.narrow(CompositeTransport.class);
        if (ct != null && this.localUri != null) {
            ct.add(new URI[]{this.localUri});
        }
        return transport;
    }
}

