/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.proxy;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.io.IOException;
import org.activemq.Service;
import org.activemq.command.Command;
import org.activemq.transport.Transport;
import org.activemq.transport.TransportListener;
import org.activemq.util.IOExceptionSupport;
import org.activemq.util.ServiceStopper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ProxyConnection
implements Service {
    private static final Log log = LogFactory.getLog((Class)ProxyConnection.class);
    private final Transport localTransport;
    private final Transport remoteTransport;
    private AtomicBoolean shuttingDown = new AtomicBoolean(false);
    private AtomicBoolean running = new AtomicBoolean(false);
    static /* synthetic */ Class class$org$activemq$command$ShutdownInfo;

    public ProxyConnection(Transport localTransport, Transport remoteTransport) {
        this.localTransport = localTransport;
        this.remoteTransport = remoteTransport;
    }

    public void onFailure(IOException e) {
        if (!this.shuttingDown.get()) {
            log.debug((Object)("Transport error: " + e), (Throwable)e);
            try {
                this.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void start() throws Exception {
        if (!this.running.compareAndSet(false, true)) {
            return;
        }
        this.localTransport.setTransportListener(new TransportListener(){

            public void onCommand(Command command) {
                boolean shutdown = false;
                if (command.getClass() == (class$org$activemq$command$ShutdownInfo == null ? (class$org$activemq$command$ShutdownInfo = ProxyConnection.class$("org.activemq.command.ShutdownInfo")) : class$org$activemq$command$ShutdownInfo)) {
                    ProxyConnection.this.shuttingDown.set(true);
                    shutdown = true;
                }
                try {
                    ProxyConnection.this.remoteTransport.oneway(command);
                    if (shutdown) {
                        ProxyConnection.this.stop();
                    }
                }
                catch (IOException error) {
                    ProxyConnection.this.onFailure(error);
                }
                catch (Exception error) {
                    ProxyConnection.this.onFailure(IOExceptionSupport.create(error));
                }
            }

            public void onException(IOException error) {
                ProxyConnection.this.onFailure(error);
            }
        });
        this.remoteTransport.setTransportListener(new TransportListener(){

            public void onCommand(Command command) {
                try {
                    ProxyConnection.this.localTransport.oneway(command);
                }
                catch (IOException error) {
                    ProxyConnection.this.onFailure(error);
                }
            }

            public void onException(IOException error) {
                ProxyConnection.this.onFailure(error);
            }
        });
        this.localTransport.start();
        this.remoteTransport.start();
    }

    public void stop() throws Exception {
        if (!this.running.compareAndSet(true, false)) {
            return;
        }
        this.shuttingDown.set(true);
        ServiceStopper ss = new ServiceStopper();
        ss.stop(this.localTransport);
        ss.stop(this.remoteTransport);
        ss.throwFirstException();
    }
}

