/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.openwire.v1;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.activemq.command.ActiveMQDestination;
import org.activemq.command.DataStructure;
import org.activemq.command.SubscriptionInfo;
import org.activemq.openwire.BooleanStream;
import org.activemq.openwire.DataStreamMarshaller;
import org.activemq.openwire.OpenWireFormat;

public class SubscriptionInfoMarshaller
extends DataStreamMarshaller {
    public byte getDataStructureType() {
        return 55;
    }

    public DataStructure createObject() {
        return new SubscriptionInfo();
    }

    public void unmarshal(OpenWireFormat wireFormat, Object o, DataInputStream dataIn, BooleanStream bs) throws IOException {
        super.unmarshal(wireFormat, o, dataIn, bs);
        SubscriptionInfo info = (SubscriptionInfo)o;
        info.setClientId(this.readString(dataIn, bs));
        info.setDestination((ActiveMQDestination)this.unmarsalCachedObject(wireFormat, dataIn, bs));
        info.setSelector(this.readString(dataIn, bs));
        info.setSubcriptionName(this.readString(dataIn, bs));
    }

    public int marshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        SubscriptionInfo info = (SubscriptionInfo)o;
        int rc = super.marshal1(wireFormat, o, bs);
        rc += this.writeString(info.getClientId(), bs);
        rc += this.marshal1CachedObject(wireFormat, info.getDestination(), bs);
        rc += this.writeString(info.getSelector(), bs);
        return (rc += this.writeString(info.getSubcriptionName(), bs)) + 0;
    }

    public void marshal2(OpenWireFormat wireFormat, Object o, DataOutputStream dataOut, BooleanStream bs) throws IOException {
        super.marshal2(wireFormat, o, dataOut, bs);
        SubscriptionInfo info = (SubscriptionInfo)o;
        this.writeString(info.getClientId(), dataOut, bs);
        this.marshal2CachedObject(wireFormat, info.getDestination(), dataOut, bs);
        this.writeString(info.getSelector(), dataOut, bs);
        this.writeString(info.getSubcriptionName(), dataOut, bs);
    }
}

