/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.openwire.v1;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.activemq.command.DataStructure;
import org.activemq.command.MessageId;
import org.activemq.command.ProducerId;
import org.activemq.openwire.BooleanStream;
import org.activemq.openwire.DataStreamMarshaller;
import org.activemq.openwire.OpenWireFormat;

public class MessageIdMarshaller
extends DataStreamMarshaller {
    public byte getDataStructureType() {
        return 110;
    }

    public DataStructure createObject() {
        return new MessageId();
    }

    public void unmarshal(OpenWireFormat wireFormat, Object o, DataInputStream dataIn, BooleanStream bs) throws IOException {
        super.unmarshal(wireFormat, o, dataIn, bs);
        MessageId info = (MessageId)o;
        info.setProducerId((ProducerId)this.unmarsalCachedObject(wireFormat, dataIn, bs));
        info.setProducerSequenceId(this.unmarshalLong(wireFormat, dataIn, bs));
        info.setBrokerSequenceId(this.unmarshalLong(wireFormat, dataIn, bs));
    }

    public int marshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        MessageId info = (MessageId)o;
        int rc = super.marshal1(wireFormat, o, bs);
        rc += this.marshal1CachedObject(wireFormat, info.getProducerId(), bs);
        rc += this.marshal1Long(wireFormat, info.getProducerSequenceId(), bs);
        return (rc += this.marshal1Long(wireFormat, info.getBrokerSequenceId(), bs)) + 0;
    }

    public void marshal2(OpenWireFormat wireFormat, Object o, DataOutputStream dataOut, BooleanStream bs) throws IOException {
        super.marshal2(wireFormat, o, dataOut, bs);
        MessageId info = (MessageId)o;
        this.marshal2CachedObject(wireFormat, info.getProducerId(), dataOut, bs);
        this.marshal2Long(wireFormat, info.getProducerSequenceId(), dataOut, bs);
        this.marshal2Long(wireFormat, info.getBrokerSequenceId(), dataOut, bs);
    }
}

