/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.openwire.v1;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.activemq.command.ConnectionId;
import org.activemq.command.DataStructure;
import org.activemq.command.LocalTransactionId;
import org.activemq.openwire.BooleanStream;
import org.activemq.openwire.OpenWireFormat;
import org.activemq.openwire.v1.TransactionIdMarshaller;

public class LocalTransactionIdMarshaller
extends TransactionIdMarshaller {
    public byte getDataStructureType() {
        return 111;
    }

    public DataStructure createObject() {
        return new LocalTransactionId();
    }

    public void unmarshal(OpenWireFormat wireFormat, Object o, DataInputStream dataIn, BooleanStream bs) throws IOException {
        super.unmarshal(wireFormat, o, dataIn, bs);
        LocalTransactionId info = (LocalTransactionId)o;
        info.setTransactionId(this.unmarshalLong(wireFormat, dataIn, bs));
        info.setConnectionId((ConnectionId)this.unmarsalCachedObject(wireFormat, dataIn, bs));
    }

    public int marshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        LocalTransactionId info = (LocalTransactionId)o;
        int rc = super.marshal1(wireFormat, o, bs);
        rc += this.marshal1Long(wireFormat, info.getTransactionId(), bs);
        return (rc += this.marshal1CachedObject(wireFormat, info.getConnectionId(), bs)) + 0;
    }

    public void marshal2(OpenWireFormat wireFormat, Object o, DataOutputStream dataOut, BooleanStream bs) throws IOException {
        super.marshal2(wireFormat, o, dataOut, bs);
        LocalTransactionId info = (LocalTransactionId)o;
        this.marshal2Long(wireFormat, info.getTransactionId(), dataOut, bs);
        this.marshal2CachedObject(wireFormat, info.getConnectionId(), dataOut, bs);
    }
}

