/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.openwire.v1;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.activemq.command.DataStructure;
import org.activemq.command.IntegerResponse;
import org.activemq.openwire.BooleanStream;
import org.activemq.openwire.OpenWireFormat;
import org.activemq.openwire.v1.ResponseMarshaller;

public class IntegerResponseMarshaller
extends ResponseMarshaller {
    public byte getDataStructureType() {
        return 34;
    }

    public DataStructure createObject() {
        return new IntegerResponse();
    }

    public void unmarshal(OpenWireFormat wireFormat, Object o, DataInputStream dataIn, BooleanStream bs) throws IOException {
        super.unmarshal(wireFormat, o, dataIn, bs);
        IntegerResponse info = (IntegerResponse)o;
        info.setResult(dataIn.readInt());
    }

    public int marshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        IntegerResponse info = (IntegerResponse)o;
        int rc = super.marshal1(wireFormat, o, bs);
        return rc + 4;
    }

    public void marshal2(OpenWireFormat wireFormat, Object o, DataOutputStream dataOut, BooleanStream bs) throws IOException {
        super.marshal2(wireFormat, o, dataOut, bs);
        IntegerResponse info = (IntegerResponse)o;
        dataOut.writeInt(info.getResult());
    }
}

