/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.openwire.v1;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.activemq.command.ActiveMQDestination;
import org.activemq.command.BrokerId;
import org.activemq.command.ConnectionId;
import org.activemq.command.DataStructure;
import org.activemq.command.DestinationInfo;
import org.activemq.openwire.BooleanStream;
import org.activemq.openwire.OpenWireFormat;
import org.activemq.openwire.v1.BaseCommandMarshaller;

public class DestinationInfoMarshaller
extends BaseCommandMarshaller {
    public byte getDataStructureType() {
        return 8;
    }

    public DataStructure createObject() {
        return new DestinationInfo();
    }

    public void unmarshal(OpenWireFormat wireFormat, Object o, DataInputStream dataIn, BooleanStream bs) throws IOException {
        super.unmarshal(wireFormat, o, dataIn, bs);
        DestinationInfo info = (DestinationInfo)o;
        info.setConnectionId((ConnectionId)this.unmarsalCachedObject(wireFormat, dataIn, bs));
        info.setDestination((ActiveMQDestination)this.unmarsalCachedObject(wireFormat, dataIn, bs));
        info.setOperationType(dataIn.readByte());
        info.setTimeout(this.unmarshalLong(wireFormat, dataIn, bs));
        if (bs.readBoolean()) {
            int size = dataIn.readShort();
            BrokerId[] value = new BrokerId[size];
            for (int i = 0; i < size; ++i) {
                value[i] = (BrokerId)this.unmarsalNestedObject(wireFormat, dataIn, bs);
            }
            info.setBrokerPath(value);
        } else {
            info.setBrokerPath(null);
        }
    }

    public int marshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        DestinationInfo info = (DestinationInfo)o;
        int rc = super.marshal1(wireFormat, o, bs);
        rc += this.marshal1CachedObject(wireFormat, info.getConnectionId(), bs);
        rc += this.marshal1CachedObject(wireFormat, info.getDestination(), bs);
        rc += this.marshal1Long(wireFormat, info.getTimeout(), bs);
        return (rc += this.marshalObjectArray(wireFormat, info.getBrokerPath(), bs)) + 1;
    }

    public void marshal2(OpenWireFormat wireFormat, Object o, DataOutputStream dataOut, BooleanStream bs) throws IOException {
        super.marshal2(wireFormat, o, dataOut, bs);
        DestinationInfo info = (DestinationInfo)o;
        this.marshal2CachedObject(wireFormat, info.getConnectionId(), dataOut, bs);
        this.marshal2CachedObject(wireFormat, info.getDestination(), dataOut, bs);
        dataOut.writeByte(info.getOperationType());
        this.marshal2Long(wireFormat, info.getTimeout(), dataOut, bs);
        this.marshalObjectArray(wireFormat, info.getBrokerPath(), dataOut, bs);
    }
}

