/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.openwire.v1;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.activemq.command.ConnectionId;
import org.activemq.command.DataStructure;
import org.activemq.openwire.BooleanStream;
import org.activemq.openwire.DataStreamMarshaller;
import org.activemq.openwire.OpenWireFormat;

public class ConnectionIdMarshaller
extends DataStreamMarshaller {
    public byte getDataStructureType() {
        return 120;
    }

    public DataStructure createObject() {
        return new ConnectionId();
    }

    public void unmarshal(OpenWireFormat wireFormat, Object o, DataInputStream dataIn, BooleanStream bs) throws IOException {
        super.unmarshal(wireFormat, o, dataIn, bs);
        ConnectionId info = (ConnectionId)o;
        info.setConnectionId(this.readString(dataIn, bs));
    }

    public int marshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        ConnectionId info = (ConnectionId)o;
        int rc = super.marshal1(wireFormat, o, bs);
        return (rc += this.writeString(info.getConnectionId(), bs)) + 0;
    }

    public void marshal2(OpenWireFormat wireFormat, Object o, DataOutputStream dataOut, BooleanStream bs) throws IOException {
        super.marshal2(wireFormat, o, dataOut, bs);
        ConnectionId info = (ConnectionId)o;
        this.writeString(info.getConnectionId(), dataOut, bs);
    }
}

