/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.openwire;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class BooleanStream {
    byte[] data = new byte[48];
    short arrayLimit;
    short arrayPos;
    byte bytePos;
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean readBoolean() throws IOException {
        if (!$assertionsDisabled && this.arrayPos > this.arrayLimit) {
            throw new AssertionError();
        }
        byte b = this.data[this.arrayPos];
        boolean rc = (b >> this.bytePos & 1) != 0;
        this.bytePos = (byte)(this.bytePos + 1);
        if (this.bytePos >= 8) {
            this.bytePos = 0;
            this.arrayPos = (short)(this.arrayPos + 1);
        }
        return rc;
    }

    public void writeBoolean(boolean value) throws IOException {
        if (this.bytePos == 0) {
            this.arrayLimit = (short)(this.arrayLimit + 1);
            if (this.arrayLimit >= this.data.length) {
                byte[] d = new byte[this.data.length * 2];
                System.arraycopy(this.data, 0, d, 0, this.data.length);
                this.data = d;
            }
        }
        if (value) {
            short s = this.arrayPos;
            this.data[s] = (byte)(this.data[s] | 1 << this.bytePos);
        }
        this.bytePos = (byte)(this.bytePos + 1);
        if (this.bytePos >= 8) {
            this.bytePos = 0;
            this.arrayPos = (short)(this.arrayPos + 1);
        }
    }

    public void marshal(DataOutputStream dataOut) throws IOException {
        if (this.arrayLimit < 64) {
            dataOut.writeByte(this.arrayLimit);
        } else if (this.arrayLimit < 256) {
            dataOut.writeByte(192);
            dataOut.writeByte(this.arrayLimit);
        } else {
            dataOut.writeByte(224);
            dataOut.writeShort(this.arrayLimit);
        }
        dataOut.write(this.data, 0, this.arrayLimit);
        this.clear();
    }

    public void unmarshal(DataInputStream dataIn) throws IOException {
        this.arrayLimit = dataIn.readByte();
        if ((this.arrayLimit & 0xE0) != 0) {
            this.arrayLimit = dataIn.readShort();
        } else if ((this.arrayLimit & 0xC0) != 0) {
            this.arrayLimit = (short)(dataIn.readByte() & 0xFF);
        }
        if (this.data.length < this.arrayLimit) {
            this.data = new byte[this.arrayLimit];
        }
        dataIn.readFully(this.data, 0, this.arrayLimit);
        this.clear();
    }

    public void clear() {
        this.arrayPos = 0;
        this.bytePos = 0;
    }

    public int marshalledSize() {
        if (this.arrayLimit < 64) {
            return 1 + this.arrayLimit;
        }
        return 2 + this.arrayLimit;
    }

    static {
        $assertionsDisabled = !BooleanStream.class.desiredAssertionStatus();
    }
}

