/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.network.jms;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.activemq.ActiveMQConnectionFactory;
import org.activemq.Service;
import org.activemq.broker.BrokerService;
import org.activemq.network.jms.DestinationBridge;
import org.activemq.network.jms.JmsMesageConvertor;
import org.activemq.network.jms.SimpleJmsMessageConvertor;
import org.activemq.util.LRUCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jndi.JndiTemplate;

public abstract class JmsConnector
implements Service {
    private static final Log log = LogFactory.getLog((Class)JmsConnector.class);
    protected JndiTemplate jndiTemplate;
    protected JmsMesageConvertor jmsMessageConvertor;
    private List inboundBridges = new CopyOnWriteArrayList();
    private List outboundBridges = new CopyOnWriteArrayList();
    protected int replyToDestinationCacheSize = 10000;
    protected AtomicBoolean initialized = new AtomicBoolean(false);
    protected AtomicBoolean started = new AtomicBoolean(false);
    protected ActiveMQConnectionFactory embeddedConnectionFactory;
    protected LRUCache replyToBridges = new LRUCache(){

        protected boolean removeEldestEntry(Map.Entry enty) {
            if (this.size() > this.maxCacheSize) {
                Iterator iter = this.entrySet().iterator();
                Map.Entry lru = iter.next();
                this.remove(lru.getKey());
                DestinationBridge bridge = (DestinationBridge)lru.getValue();
                try {
                    bridge.stop();
                    log.info((Object)("Expired bridge: " + bridge));
                }
                catch (Exception e) {
                    log.warn((Object)("stopping expired bridge" + bridge + " caused an exception"), (Throwable)e);
                }
            }
            return false;
        }
    };

    public boolean init() {
        boolean result = this.initialized.compareAndSet(false, true);
        if (result) {
            if (this.jndiTemplate == null) {
                this.jndiTemplate = new JndiTemplate();
            }
            if (this.jmsMessageConvertor == null) {
                this.jmsMessageConvertor = new SimpleJmsMessageConvertor();
            }
            this.replyToBridges.setMaxCacheSize(this.getReplyToDestinationCacheSize());
        }
        return result;
    }

    public void start() throws Exception {
        this.init();
        if (this.started.compareAndSet(false, true)) {
            DestinationBridge bridge;
            int i;
            for (i = 0; i < this.inboundBridges.size(); ++i) {
                bridge = (DestinationBridge)this.inboundBridges.get(i);
                bridge.start();
            }
            for (i = 0; i < this.outboundBridges.size(); ++i) {
                bridge = (DestinationBridge)this.outboundBridges.get(i);
                bridge.start();
            }
        }
    }

    public void stop() throws Exception {
        if (this.started.compareAndSet(true, false)) {
            DestinationBridge bridge;
            int i;
            for (i = 0; i < this.inboundBridges.size(); ++i) {
                bridge = (DestinationBridge)this.inboundBridges.get(i);
                bridge.stop();
            }
            for (i = 0; i < this.outboundBridges.size(); ++i) {
                bridge = (DestinationBridge)this.outboundBridges.get(i);
                bridge.stop();
            }
        }
    }

    public void setBrokerService(BrokerService service) {
        this.embeddedConnectionFactory = new ActiveMQConnectionFactory(service.getVmConnectorURI());
    }

    public JndiTemplate getJndiTemplate() {
        return this.jndiTemplate;
    }

    public void setJndiTemplate(JndiTemplate jndiTemplate) {
        this.jndiTemplate = jndiTemplate;
    }

    public JmsMesageConvertor getJmsMessageConvertor() {
        return this.jmsMessageConvertor;
    }

    public void setJmsMessageConvertor(JmsMesageConvertor jmsMessageConvertor) {
        this.jmsMessageConvertor = jmsMessageConvertor;
    }

    public int getReplyToDestinationCacheSize() {
        return this.replyToDestinationCacheSize;
    }

    public void setReplyToDestinationCacheSize(int replyToDestinationCacheSize) {
        this.replyToDestinationCacheSize = replyToDestinationCacheSize;
    }

    protected void addInboundBridge(DestinationBridge bridge) {
        this.inboundBridges.add(bridge);
    }

    protected void addOutboundBridge(DestinationBridge bridge) {
        this.outboundBridges.add(bridge);
    }

    protected void removeInboundBridge(DestinationBridge bridge) {
        this.inboundBridges.add(bridge);
    }

    protected void removeOutboundBridge(DestinationBridge bridge) {
        this.outboundBridges.add(bridge);
    }
}

