/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.network;

import java.io.IOException;
import org.activemq.command.ActiveMQQueue;
import org.activemq.command.ActiveMQTopic;
import org.activemq.command.BrokerId;
import org.activemq.command.BrokerInfo;
import org.activemq.command.Command;
import org.activemq.command.ConnectionId;
import org.activemq.command.ConnectionInfo;
import org.activemq.command.ConsumerInfo;
import org.activemq.command.Message;
import org.activemq.command.MessageAck;
import org.activemq.command.MessageDispatch;
import org.activemq.command.ProducerInfo;
import org.activemq.command.SessionInfo;
import org.activemq.command.ShutdownInfo;
import org.activemq.network.Bridge;
import org.activemq.transport.Transport;
import org.activemq.transport.TransportListener;
import org.activemq.util.IdGenerator;
import org.activemq.util.ServiceStopper;
import org.activemq.util.ServiceSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ForwardingBridge
implements Bridge {
    private static final Log log = LogFactory.getLog((Class)ForwardingBridge.class);
    private final Transport localBroker;
    private final Transport remoteBroker;
    IdGenerator idGenerator = new IdGenerator();
    ConnectionInfo connectionInfo;
    SessionInfo sessionInfo;
    ProducerInfo producerInfo;
    ConsumerInfo queueConsumerInfo;
    ConsumerInfo topicConsumerInfo;
    private String clientId;
    private int prefetchSize = 1000;
    private boolean dispatchAsync;
    private String destinationFilter = ">";
    private int queueDispatched;
    private int topicDispatched;
    BrokerId localBrokerId;
    BrokerId remoteBrokerId;

    public ForwardingBridge(Transport localBroker, Transport remoteBroker) {
        this.localBroker = localBroker;
        this.remoteBroker = remoteBroker;
    }

    public void start() throws Exception {
        log.info((Object)("Starting a network connection between " + this.localBroker + " and " + this.remoteBroker + " has been established."));
        this.localBroker.setTransportListener(new TransportListener(){

            public void onCommand(Command command) {
                ForwardingBridge.this.serviceLocalCommand(command);
            }

            public void onException(IOException error) {
                ForwardingBridge.this.serviceLocalException(error);
            }
        });
        this.remoteBroker.setTransportListener(new TransportListener(){

            public void onCommand(Command command) {
                ForwardingBridge.this.serviceRemoteCommand(command);
            }

            public void onException(IOException error) {
                ForwardingBridge.this.serviceRemoteException(error);
            }
        });
        this.localBroker.start();
        this.remoteBroker.start();
    }

    protected void triggerStartBridge() throws IOException {
        Thread thead = new Thread(){

            public void run() {
                try {
                    ForwardingBridge.this.startBridge();
                }
                catch (IOException e) {
                    log.error((Object)("Failed to start network bridge: " + e), (Throwable)e);
                }
            }
        };
        thead.start();
    }

    private void startBridge() throws IOException {
        this.connectionInfo = new ConnectionInfo();
        this.connectionInfo.setConnectionId(new ConnectionId(this.idGenerator.generateId()));
        this.connectionInfo.setClientId(this.clientId);
        this.localBroker.oneway(this.connectionInfo);
        this.remoteBroker.oneway(this.connectionInfo);
        this.sessionInfo = new SessionInfo(this.connectionInfo, 1L);
        this.localBroker.oneway(this.sessionInfo);
        this.remoteBroker.oneway(this.sessionInfo);
        this.queueConsumerInfo = new ConsumerInfo(this.sessionInfo, 1L);
        this.queueConsumerInfo.setDispatchAsync(this.dispatchAsync);
        this.queueConsumerInfo.setDestination(new ActiveMQQueue(this.destinationFilter));
        this.queueConsumerInfo.setPrefetchSize(this.prefetchSize);
        this.queueConsumerInfo.setPriority((byte)-5);
        this.localBroker.oneway(this.queueConsumerInfo);
        this.producerInfo = new ProducerInfo(this.sessionInfo, 1L);
        this.producerInfo.setResponseRequired(false);
        this.remoteBroker.oneway(this.producerInfo);
        if (this.connectionInfo.getClientId() != null) {
            this.topicConsumerInfo = new ConsumerInfo(this.sessionInfo, 2L);
            this.topicConsumerInfo.setDispatchAsync(this.dispatchAsync);
            this.topicConsumerInfo.setSubcriptionName("topic-bridge");
            this.topicConsumerInfo.setRetroactive(true);
            this.topicConsumerInfo.setDestination(new ActiveMQTopic(this.destinationFilter));
            this.topicConsumerInfo.setPrefetchSize(this.prefetchSize);
            this.topicConsumerInfo.setPriority((byte)-5);
            this.localBroker.oneway(this.topicConsumerInfo);
        }
        log.info((Object)("Network connection between " + this.localBroker + " and " + this.remoteBroker + " has been established."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        try {
            if (this.connectionInfo != null) {
                this.localBroker.request(this.connectionInfo.createRemoveCommand());
                this.remoteBroker.request(this.connectionInfo.createRemoveCommand());
            }
            this.localBroker.setTransportListener(null);
            this.remoteBroker.setTransportListener(null);
            this.localBroker.oneway(new ShutdownInfo());
            this.remoteBroker.oneway(new ShutdownInfo());
        }
        finally {
            ServiceStopper ss = new ServiceStopper();
            ss.stop(this.localBroker);
            ss.stop(this.remoteBroker);
            ss.throwFirstException();
        }
    }

    protected void serviceRemoteException(IOException error) {
        System.out.println("Unexpected remote exception: " + error);
        error.printStackTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceRemoteCommand(Command command) {
        block9: {
            try {
                if (command.isBrokerInfo()) {
                    ForwardingBridge forwardingBridge = this;
                    synchronized (forwardingBridge) {
                        this.remoteBrokerId = ((BrokerInfo)command).getBrokerId();
                        if (this.localBrokerId != null) {
                            if (this.localBrokerId.equals(this.remoteBrokerId)) {
                                log.info((Object)"Disconnecting loop back connection.");
                                ServiceSupport.dispose(this);
                            } else {
                                this.triggerStartBridge();
                            }
                        }
                        break block9;
                    }
                }
                System.out.println("Unexpected remote command: " + command);
            }
            catch (IOException e) {
                this.serviceLocalException(e);
            }
        }
    }

    protected void serviceLocalException(IOException error) {
        System.out.println("Unexpected local exception: " + error);
        error.printStackTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceLocalCommand(Command command) {
        block15: {
            try {
                if (command.isMessageDispatch()) {
                    MessageDispatch md = (MessageDispatch)command;
                    Message message = md.getMessage();
                    message.setProducerId(this.producerInfo.getProducerId());
                    message.setDestination(md.getDestination());
                    if (message.getOriginalTransactionId() == null) {
                        message.setOriginalTransactionId(message.getTransactionId());
                    }
                    message.setTransactionId(null);
                    message.evictMarshlledForm();
                    this.remoteBroker.oneway(message);
                    if (md.getConsumerId().equals(this.queueConsumerInfo.getConsumerId())) {
                        ++this.queueDispatched;
                        if (this.queueDispatched > this.queueConsumerInfo.getPrefetchSize() / 2) {
                            this.localBroker.oneway(new MessageAck(md, 2, this.queueDispatched));
                            this.queueDispatched = 0;
                        }
                    } else {
                        ++this.topicDispatched;
                        if (this.topicDispatched > this.topicConsumerInfo.getPrefetchSize() / 2) {
                            this.localBroker.oneway(new MessageAck(md, 2, this.topicDispatched));
                            this.topicDispatched = 0;
                        }
                    }
                    break block15;
                }
                if (command.isBrokerInfo()) {
                    ForwardingBridge md = this;
                    synchronized (md) {
                        this.localBrokerId = ((BrokerInfo)command).getBrokerId();
                        if (this.remoteBrokerId != null) {
                            if (this.remoteBrokerId.equals(this.localBrokerId)) {
                                log.info((Object)"Disconnecting loop back connection.");
                                ServiceSupport.dispose(this);
                            } else {
                                this.triggerStartBridge();
                            }
                        }
                        break block15;
                    }
                }
                System.out.println("Unexpected local command: " + command);
            }
            catch (IOException e) {
                this.serviceLocalException(e);
            }
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public int getPrefetchSize() {
        return this.prefetchSize;
    }

    public void setPrefetchSize(int prefetchSize) {
        this.prefetchSize = prefetchSize;
    }

    public boolean isDispatchAsync() {
        return this.dispatchAsync;
    }

    public void setDispatchAsync(boolean dispatchAsync) {
        this.dispatchAsync = dispatchAsync;
    }

    public String getDestinationFilter() {
        return this.destinationFilter;
    }

    public void setDestinationFilter(String destinationFilter) {
        this.destinationFilter = destinationFilter;
    }
}

