/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.management;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.util.List;
import org.activemq.ActiveMQConnection;
import org.activemq.management.JMSConnectionStatsImpl;
import org.activemq.management.StatsImpl;
import org.activemq.util.IndentPrinter;

public class JMSStatsImpl
extends StatsImpl {
    private List connections = new CopyOnWriteArrayList();

    public JMSConnectionStatsImpl[] getConnections() {
        Object[] connectionArray = this.connections.toArray();
        int size = connectionArray.length;
        JMSConnectionStatsImpl[] answer = new JMSConnectionStatsImpl[size];
        for (int i = 0; i < size; ++i) {
            ActiveMQConnection connection = (ActiveMQConnection)connectionArray[i];
            answer[i] = connection.getConnectionStats();
        }
        return answer;
    }

    public void addConnection(ActiveMQConnection connection) {
        this.connections.add(connection);
    }

    public void removeConnection(ActiveMQConnection connection) {
        this.connections.remove(connection);
    }

    public void dump(IndentPrinter out) {
        out.printIndent();
        out.println("factory {");
        out.incrementIndent();
        JMSConnectionStatsImpl[] array = this.getConnections();
        for (int i = 0; i < array.length; ++i) {
            JMSConnectionStatsImpl connectionStat = array[i];
            connectionStat.dump(out);
        }
        out.decrementIndent();
        out.printIndent();
        out.println("}");
        out.flush();
    }
}

