/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.command;

import org.activemq.command.ConnectionId;
import org.activemq.command.ConsumerId;
import org.activemq.command.DataStructure;
import org.activemq.command.ProducerId;

public class SessionId
implements DataStructure {
    public static final byte DATA_STRUCTURE_TYPE = 121;
    protected String connectionId;
    protected long sessionId;
    protected transient int hashCode;
    protected transient String key;
    protected transient ConnectionId parentId;

    public SessionId() {
    }

    public SessionId(ConnectionId connectionId, long sessionId) {
        this.connectionId = connectionId.getConnectionId();
        this.sessionId = sessionId;
    }

    public SessionId(SessionId id) {
        this.connectionId = id.getConnectionId();
        this.sessionId = id.getSessionId();
    }

    public SessionId(ProducerId id) {
        this.connectionId = id.getConnectionId();
        this.sessionId = id.getSessionId();
    }

    public SessionId(ConsumerId id) {
        this.connectionId = id.getConnectionId();
        this.sessionId = id.getSessionId();
    }

    public ConnectionId getParentId() {
        if (this.parentId == null) {
            this.parentId = new ConnectionId(this);
        }
        return this.parentId;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.connectionId.hashCode() ^ (int)this.sessionId;
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != SessionId.class) {
            return false;
        }
        SessionId id = (SessionId)o;
        return this.sessionId == id.sessionId && this.connectionId.equals(id.connectionId);
    }

    public byte getDataStructureType() {
        return 121;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(long sessionId) {
        this.sessionId = sessionId;
    }

    public String toString() {
        if (this.key == null) {
            this.key = this.connectionId + ":" + this.sessionId;
        }
        return this.key;
    }

    public boolean isMarshallAware() {
        return false;
    }
}

