/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker.region;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.activemq.broker.ConnectionContext;
import org.activemq.broker.region.Destination;
import org.activemq.broker.region.DestinationStatistics;
import org.activemq.broker.region.IndirectMessageReference;
import org.activemq.broker.region.MessageReference;
import org.activemq.broker.region.Subscription;
import org.activemq.broker.region.policy.DispatchPolicy;
import org.activemq.broker.region.policy.RoundRobinDispatchPolicy;
import org.activemq.command.ActiveMQDestination;
import org.activemq.command.ConsumerId;
import org.activemq.command.Message;
import org.activemq.command.MessageAck;
import org.activemq.command.MessageId;
import org.activemq.filter.MessageEvaluationContext;
import org.activemq.memory.UsageManager;
import org.activemq.store.MessageRecoveryListener;
import org.activemq.store.MessageStore;
import org.activemq.thread.TaskRunnerFactory;
import org.activemq.thread.Valve;
import org.activemq.transaction.Synchronization;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Queue
implements Destination {
    private final Log log;
    protected final ActiveMQDestination destination;
    protected final CopyOnWriteArrayList consumers = new CopyOnWriteArrayList();
    protected final LinkedList messages = new LinkedList();
    protected final Valve dispatchValve = new Valve(true);
    protected final UsageManager usageManager;
    protected final DestinationStatistics destinationStatistics = new DestinationStatistics();
    private Subscription exclusiveOwner;
    private final ConcurrentHashMap messageGroupOwners = new ConcurrentHashMap();
    protected long garbageSize = 0L;
    protected long garbageSizeBeforeCollection = 1000L;
    private DispatchPolicy dispatchPolicy = new RoundRobinDispatchPolicy();
    protected final MessageStore store;
    protected int highestSubscriptionPriority;

    public Queue(ActiveMQDestination destination, UsageManager memoryManager, MessageStore store, DestinationStatistics parentStats, TaskRunnerFactory taskFactory) throws Throwable {
        this.destination = destination;
        this.usageManager = memoryManager;
        this.store = store;
        this.destinationStatistics.setParent(parentStats);
        this.log = LogFactory.getLog((String)(this.getClass().getName() + "." + destination.getPhysicalName()));
        if (store != null) {
            store.recover(new MessageRecoveryListener(){

                public void recoverMessage(Message message) {
                    message.setRegionDestination(Queue.this);
                    MessageReference reference = Queue.this.createMessageReference(message);
                    Queue.this.messages.add(reference);
                    reference.decrementReferenceCount();
                    Queue.this.destinationStatistics.getMessages().increment();
                }

                public void recoverMessageReference(String messageReference) throws Throwable {
                    throw new RuntimeException("Should not be called.");
                }
            });
        }
    }

    public synchronized boolean lock(MessageReference node, Subscription sub) {
        if (this.exclusiveOwner == sub) {
            return true;
        }
        if (this.exclusiveOwner != null) {
            return false;
        }
        if (sub.getConsumerInfo().getPriority() != this.highestSubscriptionPriority) {
            return false;
        }
        if (sub.getConsumerInfo().isExclusive()) {
            this.exclusiveOwner = sub;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscription(ConnectionContext context, Subscription sub) throws Throwable {
        sub.add(context, this);
        this.destinationStatistics.getConsumers().increment();
        this.dispatchValve.turnOff();
        MessageEvaluationContext msgContext = context.getMessageEvaluationContext();
        try {
            this.consumers.add((Object)sub);
            this.highestSubscriptionPriority = this.calcHighestSubscriptionPriority();
            msgContext.setDestination(this.destination);
            LinkedList linkedList = this.messages;
            synchronized (linkedList) {
                Iterator iter = this.messages.iterator();
                while (iter.hasNext()) {
                    IndirectMessageReference node = (IndirectMessageReference)iter.next();
                    if (node.isDropped()) continue;
                    try {
                        msgContext.setMessageReference(node);
                        if (!sub.matches(node, msgContext)) continue;
                        sub.add(node);
                    }
                    catch (IOException e) {
                        this.log.warn((Object)("Could not load message: " + e), (Throwable)e);
                    }
                }
            }
        }
        finally {
            msgContext.clear();
            this.dispatchValve.turnOn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscription(ConnectionContext context, Subscription sub) throws Throwable {
        this.destinationStatistics.getConsumers().decrement();
        this.dispatchValve.turnOff();
        try {
            this.consumers.remove((Object)sub);
            sub.remove(context, this);
            this.highestSubscriptionPriority = this.calcHighestSubscriptionPriority();
            boolean wasExclusiveOwner = false;
            if (this.exclusiveOwner == sub) {
                this.exclusiveOwner = null;
                wasExclusiveOwner = true;
            }
            HashSet<String> ownedGroups = new HashSet<String>();
            ConsumerId consumerId = sub.getConsumerInfo().getConsumerId();
            Iterator iter = this.messageGroupOwners.keySet().iterator();
            while (iter.hasNext()) {
                String group = (String)iter.next();
                ConsumerId owner = (ConsumerId)this.messageGroupOwners.get((Object)group);
                if (!owner.equals(consumerId)) continue;
                ownedGroups.add(group);
                iter.remove();
            }
            LinkedList linkedList = this.messages;
            synchronized (linkedList) {
                if (!sub.getConsumerInfo().isBrowser()) {
                    MessageEvaluationContext msgContext = context.getMessageEvaluationContext();
                    try {
                        msgContext.setDestination(this.destination);
                        Iterator iter2 = this.messages.iterator();
                        while (iter2.hasNext()) {
                            IndirectMessageReference node = (IndirectMessageReference)iter2.next();
                            if (node.isDropped()) continue;
                            String groupID = node.getGroupID();
                            if (node.getLockOwner() != sub && !wasExclusiveOwner && (groupID == null || !ownedGroups.contains(groupID))) continue;
                            node.incrementRedeliveryCounter();
                            node.unlock();
                            msgContext.setMessageReference(node);
                            this.dispatchPolicy.dispatch(context, node, msgContext, this.consumers);
                        }
                    }
                    finally {
                        msgContext.clear();
                    }
                }
            }
        }
        finally {
            this.dispatchValve.turnOn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(final ConnectionContext context, final Message message) throws Throwable {
        if (context.isProducerFlowControl()) {
            this.usageManager.waitForSpace();
        }
        message.setRegionDestination(this);
        if (this.store != null && message.isPersistent()) {
            this.store.addMessage(context, message);
        }
        final MessageReference node = this.createMessageReference(message);
        try {
            if (context.isInTransaction()) {
                context.getTransaction().addSynchronization(new Synchronization(){

                    public void afterCommit() throws Throwable {
                        Queue.this.dispatch(context, node, message);
                    }
                });
            } else {
                this.dispatch(context, node, message);
            }
        }
        finally {
            node.decrementReferenceCount();
        }
    }

    public void dispose(ConnectionContext context) throws IOException {
        if (this.store != null) {
            this.store.removeAllMessages(context);
        }
        this.destinationStatistics.setParent(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropEvent() {
        this.destinationStatistics.getMessages().decrement();
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            ++this.garbageSize;
            if (this.garbageSize > this.garbageSizeBeforeCollection) {
                this.gc();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gc() {
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            Iterator iter = this.messages.iterator();
            while (iter.hasNext()) {
                IndirectMessageReference node = (IndirectMessageReference)iter.next();
                if (!node.isDropped()) continue;
                --this.garbageSize;
                iter.remove();
            }
        }
    }

    public void acknowledge(ConnectionContext context, Subscription sub, MessageAck ack, MessageReference node) throws IOException {
        if (this.store != null && node.isPersistent()) {
            this.store.removeMessage(context, ack);
        }
    }

    public Message loadMessage(MessageId messageId) throws IOException {
        Message msg = this.store.getMessage(messageId);
        if (msg != null) {
            msg.setRegionDestination(this);
        }
        return msg;
    }

    public String toString() {
        return "Queue: destination=" + this.destination.getPhysicalName() + ", subscriptions=" + this.consumers.size() + ", memory=" + this.usageManager.getPercentUsage() + "%, size=" + this.messages.size() + ", in flight groups=" + this.messageGroupOwners.size();
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public ActiveMQDestination getActiveMQDestination() {
        return this.destination;
    }

    public UsageManager getUsageManager() {
        return this.usageManager;
    }

    public DestinationStatistics getDestinationStatistics() {
        return this.destinationStatistics;
    }

    public ConcurrentHashMap getMessageGroupOwners() {
        return this.messageGroupOwners;
    }

    public DispatchPolicy getDispatchPolicy() {
        return this.dispatchPolicy;
    }

    public void setDispatchPolicy(DispatchPolicy dispatchPolicy) {
        this.dispatchPolicy = dispatchPolicy;
    }

    private MessageReference createMessageReference(Message message) {
        return new IndirectMessageReference(this, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch(ConnectionContext context, MessageReference node, Message message) throws Throwable {
        this.dispatchValve.increment();
        MessageEvaluationContext msgContext = context.getMessageEvaluationContext();
        try {
            this.destinationStatistics.getEnqueues().increment();
            this.destinationStatistics.getMessages().increment();
            LinkedList linkedList = this.messages;
            synchronized (linkedList) {
                this.messages.add(node);
            }
            if (this.consumers.isEmpty()) {
                return;
            }
            msgContext.setDestination(this.destination);
            msgContext.setMessageReference(node);
            this.dispatchPolicy.dispatch(context, node, msgContext, this.consumers);
        }
        finally {
            msgContext.clear();
            this.dispatchValve.decrement();
        }
    }

    private int calcHighestSubscriptionPriority() {
        byte by;
        int n = Integer.MIN_VALUE;
        Iterator iter = this.consumers.iterator();
        while (iter.hasNext()) {
            Subscription sub = (Subscription)iter.next();
            if (sub.getConsumerInfo().getPriority() <= by) continue;
            by = sub.getConsumerInfo().getPriority();
        }
        return by;
    }

    public MessageStore getMessageStore() {
        return this.store;
    }
}

