/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker.jmx;

import java.io.IOException;
import java.util.Hashtable;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.activemq.broker.Broker;
import org.activemq.broker.TransportConnection;
import org.activemq.broker.TransportConnector;
import org.activemq.broker.jmx.ConnectionView;
import org.activemq.broker.jmx.ConnectionViewMBean;
import org.activemq.command.ConnectionInfo;
import org.activemq.command.Response;
import org.activemq.thread.TaskRunnerFactory;
import org.activemq.transport.Transport;
import org.activemq.util.IOExceptionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagedTransportConnection
extends TransportConnection {
    private static final Log log = LogFactory.getLog((Class)ManagedTransportConnection.class);
    private final MBeanServer server;
    private final ObjectName connectorName;
    private ConnectionViewMBean mbean;
    private ObjectName name;
    private String connectionId;

    public ManagedTransportConnection(TransportConnector connector, Transport transport, Broker broker, TaskRunnerFactory factory, MBeanServer server, ObjectName connectorName, String connectionId) throws IOException {
        super(connector, transport, broker, factory);
        this.server = server;
        this.connectorName = connectorName;
        this.mbean = new ConnectionView(this);
        this.setConnectionId(connectionId);
    }

    public void stop() throws Exception {
        this.unregisterMBean();
        super.stop();
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(String connectionId) throws IOException {
        this.connectionId = connectionId;
        this.unregisterMBean();
        this.name = this.createObjectName();
        this.registerMBean();
    }

    public Response processAddConnection(ConnectionInfo info) throws Throwable {
        Response answer = super.processAddConnection(info);
        String clientId = info.getClientId();
        if (clientId != null) {
            this.setConnectionId(clientId);
        }
        return answer;
    }

    protected void registerMBean() throws IOException {
        try {
            this.server.registerMBean(this.mbean, this.name);
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create(e);
        }
    }

    protected void unregisterMBean() {
        if (this.name != null) {
            try {
                this.server.unregisterMBean(this.name);
            }
            catch (Throwable e) {
                log.warn((Object)("Failed to unregister mbean: " + this.name));
            }
        }
    }

    protected ObjectName createObjectName() throws IOException {
        Hashtable<String, String> map = new Hashtable<String, String>(this.connectorName.getKeyPropertyList());
        map.put("Type", "Connection");
        map.put("Connection", this.connectionId);
        try {
            return new ObjectName(this.connectorName.getDomain(), map);
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create(e);
        }
    }
}

