/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;

public class Main {
    private static final String BROKER_FACTORY_CLASS = "org.activemq.broker.BrokerFactory";
    private static File activeMQHome;
    private final ArrayList extensions = new ArrayList();
    private URI uri;
    private ClassLoader classLoader;

    public static void main(String[] args) throws Throwable {
        Main main = new Main();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-D")) {
                String key = args[i].substring(2);
                String value = "";
                int pos = key.indexOf("=");
                if (pos >= 0) {
                    value = key.substring(pos + 1);
                    key = key.substring(0, pos);
                }
                System.setProperty(key, value);
                continue;
            }
            if (args[i].equals("--extdir")) {
                if (!Main.canUseExtdir()) {
                    System.out.println("Extension directory feature not available due to the system classpath being able to load: org.activemq.broker.BrokerFactory");
                    Main.printUsage();
                    return;
                }
                if (++i >= args.length) {
                    System.out.println("Extension directory not specified.");
                    Main.printUsage();
                    return;
                }
                File directory = new File(args[i]);
                if (!directory.isDirectory()) {
                    System.out.println("Extension directory specified is not valid directory: " + directory);
                    Main.printUsage();
                    return;
                }
                main.addExtensionDirectory(directory);
                continue;
            }
            if (args[i].equals("--version")) {
                System.out.println();
                System.out.println("ActiveMQ " + main.getVersion());
                System.out.println("For help or more information please see: http://www.logicblaze.com");
                System.out.println();
                return;
            }
            if (args[i].equals("-h") || args[i].equals("--help") || args[i].equals("-?")) {
                Main.printUsage();
                return;
            }
            if (main.getUri() != null) {
                System.out.println("Multiple configuration uris cannot be specified.");
                Main.printUsage();
                return;
            }
            try {
                main.setUri(new URI(args[i]));
                continue;
            }
            catch (URISyntaxException e) {
                System.out.println("Invalid broker configuration URI: " + args[i] + ", reason: " + e.getMessage());
                Main.printUsage();
                return;
            }
        }
        if (Main.canUseExtdir()) {
            main.addExtensionDirectory(new File(main.getActiveMQHome(), "conf"));
            main.addExtensionDirectory(new File(main.getActiveMQHome(), "lib"));
            main.addExtensionDirectory(new File(new File(main.getActiveMQHome(), "lib"), "optional"));
        }
        if (main.getUri() == null) {
            main.setUri(Main.getDefaultUri());
        }
        main.run();
    }

    public static URI getDefaultUri() {
        try {
            return new URI("xbean:activemq.xml");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean canUseExtdir() {
        try {
            Main.class.getClassLoader().loadClass(BROKER_FACTORY_CLASS);
            return false;
        }
        catch (ClassNotFoundException e) {
            return true;
        }
    }

    private static void printUsage() {
        System.out.println();
        System.out.println("Usage: Main [options] uri");
        System.out.println();
        System.out.println("Options:");
        if (Main.canUseExtdir()) {
            System.out.println(" --extdir dir   Add the jar files in the directory to the classpath.");
        }
        System.out.println(" -Dname=value   Define a system property");
        System.out.println(" --version      Display version information");
        System.out.println(" -h,-?,--help   Display help information");
        System.out.println();
        System.out.println("URI:");
        System.out.println();
        System.out.println(" XBean based broker configuration:");
        System.out.println("    ");
        System.out.println();
        System.out.println("    Example: Main xbean:file:activemq.xml");
        System.out.println("        Loads the xbean configuration file from the current working directory");
        System.out.println("    Example: Main xbean:activemq.xml");
        System.out.println("        Loads the xbean configuration file from the classpath");
        System.out.println();
        System.out.println(" Spring based broker configuration:");
        System.out.println("    ");
        System.out.println("    Example: Main spring:file:activemq.xml");
        System.out.println("        Loads the spring configuration file from the current working directory");
        System.out.println("    Example: Main spring:activemq.xml");
        System.out.println("        Loads the spring configuration file from the classpath");
        System.out.println();
        System.out.println(" URI Parameter based broker configuration:");
        System.out.println("    Example: Main broker:(tcp://localhost:61616, tcp://localhost:5000)?useJmx=true");
        System.out.println("        Configures the broker with 2 transport connectors and jmx enabled");
        System.out.println("    Example: Main broker:(tcp://localhost:61616, network:tcp://localhost:5000)?persistent=false");
        System.out.println("        Configures the broker with 1 transport connector, and 1 network connector and persistence disabled");
        System.out.println();
    }

    public String getVersion() throws Throwable {
        ClassLoader cl = this.getClassLoader();
        Class<?> activeMQConnectionMetaData = cl.loadClass("org.activemq.ActiveMQConnectionMetaData");
        Field field = activeMQConnectionMetaData.getField("PROVIDER_VERSION");
        return (String)field.get(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Throwable {
        Object broker;
        Object createBroker;
        System.out.println("Loading Message Broker from: " + this.uri);
        System.out.println("ACTIVEMQ_HOME: " + this.getActiveMQHome());
        ClassLoader cl = this.getClassLoader();
        try {
            Class<?> brokerFactory = cl.loadClass(BROKER_FACTORY_CLASS);
            createBroker = brokerFactory.getMethod("createBroker", URI.class);
            broker = ((Method)createBroker).invoke(null, this.uri);
            Method start = broker.getClass().getMethod("start", new Class[0]);
            start.invoke(broker, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        catch (Throwable e) {
            throw e;
        }
        final boolean[] shutdown = new boolean[]{false};
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean[] blArray = shutdown;
                synchronized (shutdown) {
                    shutdown[0] = true;
                    shutdown.notify();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
        createBroker = shutdown;
        synchronized (shutdown) {
            while (!shutdown[0]) {
                shutdown.wait();
            }
            // ** MonitorExit[createBroker] (shouldn't be in output)
            try {
                Method stop = broker.getClass().getMethod("stop", new Class[0]);
                stop.invoke(broker, new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            catch (Throwable e) {
                throw e;
            }
            return;
        }
    }

    public ClassLoader getClassLoader() throws MalformedURLException {
        if (this.classLoader == null) {
            this.classLoader = Main.class.getClassLoader();
            if (!this.extensions.isEmpty()) {
                ArrayList<URL> urls = new ArrayList<URL>();
                Iterator iter = this.extensions.iterator();
                while (iter.hasNext()) {
                    File dir = (File)iter.next();
                    urls.add(dir.toURL());
                    File[] files = dir.listFiles();
                    if (files == null) continue;
                    for (int j = 0; j < files.length; ++j) {
                        if (!files[j].getName().endsWith(".zip") && !files[j].getName().endsWith(".jar")) continue;
                        urls.add(files[j].toURL());
                    }
                }
                URL[] u = new URL[urls.size()];
                urls.toArray(u);
                this.classLoader = new URLClassLoader(u, this.classLoader);
            }
            Thread.currentThread().setContextClassLoader(this.classLoader);
        }
        return this.classLoader;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI config) {
        this.uri = config;
    }

    public void addExtensionDirectory(File directory) {
        this.extensions.add(directory);
    }

    public File getActiveMQHome() {
        if (activeMQHome == null) {
            URL url;
            if (System.getProperty("activemq.home") != null) {
                activeMQHome = new File(System.getProperty("activemq.home"));
            }
            if (activeMQHome == null && (url = Main.class.getClassLoader().getResource("org/activemq/broker/Main.class")) != null) {
                try {
                    JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
                    url = jarConnection.getJarFileURL();
                    URI baseURI = new URI(url.toString()).resolve("..");
                    activeMQHome = new File(baseURI).getCanonicalFile();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (activeMQHome == null) {
                activeMQHome = new File(".");
            }
        }
        return activeMQHome;
    }

    public static void setActiveMQHome(File activeMQHome) {
        Main.activeMQHome = activeMQHome;
    }
}

