/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.advisory;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.Iterator;
import org.activemq.advisory.AdvisorySupport;
import org.activemq.broker.Broker;
import org.activemq.broker.BrokerFilter;
import org.activemq.broker.ConnectionContext;
import org.activemq.broker.region.Destination;
import org.activemq.command.ActiveMQDestination;
import org.activemq.command.ActiveMQMessage;
import org.activemq.command.ActiveMQTopic;
import org.activemq.command.BaseCommand;
import org.activemq.command.Command;
import org.activemq.command.ConnectionInfo;
import org.activemq.command.ConsumerId;
import org.activemq.command.ConsumerInfo;
import org.activemq.command.DestinationInfo;
import org.activemq.command.MessageId;
import org.activemq.command.ProducerId;
import org.activemq.command.ProducerInfo;
import org.activemq.util.IdGenerator;
import org.activemq.util.LongSequenceGenerator;

public class AdvisoryBroker
extends BrokerFilter {
    protected final ConcurrentHashMap connections = new ConcurrentHashMap();
    protected final ConcurrentHashMap consumers = new ConcurrentHashMap();
    protected final ConcurrentHashMap producers = new ConcurrentHashMap();
    protected final ConcurrentHashMap destinations = new ConcurrentHashMap();
    private static final IdGenerator idGenerator = new IdGenerator();
    protected final ProducerId advisoryProducerId = new ProducerId();
    private final LongSequenceGenerator messageIdGenerator = new LongSequenceGenerator();

    public AdvisoryBroker(Broker next) {
        super(next);
        this.advisoryProducerId.setConnectionId(idGenerator.generateId());
    }

    public void addConnection(ConnectionContext context, ConnectionInfo info) throws Throwable {
        this.next.addConnection(context, info);
        ActiveMQTopic topic = AdvisorySupport.getConnectionAdvisoryTopic();
        this.fireAdvisory(context, topic, info);
        this.connections.put((Object)info.getConnectionId(), (Object)info);
    }

    public void addConsumer(ConnectionContext context, ConsumerInfo info) throws Throwable {
        this.next.addConsumer(context, info);
        if (!AdvisorySupport.isAdvisoryTopic(info.getDestination())) {
            ActiveMQTopic topic = AdvisorySupport.getConsumerAdvisoryTopic(info.getDestination());
            this.fireAdvisory(context, topic, info);
            this.consumers.put((Object)info.getConsumerId(), (Object)info);
        } else {
            ActiveMQTopic topic;
            BaseCommand value;
            Iterator iter;
            if (AdvisorySupport.isConnectionAdvisoryTopic(info.getDestination())) {
                iter = this.connections.values().iterator();
                while (iter.hasNext()) {
                    value = (ConnectionInfo)iter.next();
                    topic = AdvisorySupport.getConnectionAdvisoryTopic();
                    this.fireAdvisory(context, topic, value, info.getConsumerId());
                }
            }
            if (AdvisorySupport.isDestinationAdvisoryTopic(info.getDestination())) {
                iter = this.destinations.values().iterator();
                while (iter.hasNext()) {
                    value = (DestinationInfo)iter.next();
                    topic = AdvisorySupport.getDestinationAdvisoryTopic(((DestinationInfo)value).getDestination());
                    this.fireAdvisory(context, topic, value, info.getConsumerId());
                }
            }
            if (AdvisorySupport.isProducerAdvisoryTopic(info.getDestination())) {
                iter = this.producers.values().iterator();
                while (iter.hasNext()) {
                    value = (ProducerInfo)iter.next();
                    topic = AdvisorySupport.getProducerAdvisoryTopic(((ProducerInfo)value).getDestination());
                    this.fireAdvisory(context, topic, value, info.getConsumerId());
                }
            }
            if (AdvisorySupport.isConsumerAdvisoryTopic(info.getDestination())) {
                iter = this.consumers.values().iterator();
                while (iter.hasNext()) {
                    value = (ConsumerInfo)iter.next();
                    topic = AdvisorySupport.getConsumerAdvisoryTopic(((ConsumerInfo)value).getDestination());
                    this.fireAdvisory(context, topic, value, info.getConsumerId());
                }
            }
        }
    }

    public void addProducer(ConnectionContext context, ProducerInfo info) throws Throwable {
        this.next.addProducer(context, info);
        if (info.getDestination() != null && !AdvisorySupport.isAdvisoryTopic(info.getDestination())) {
            ActiveMQTopic topic = AdvisorySupport.getProducerAdvisoryTopic(info.getDestination());
            this.fireAdvisory(context, topic, info);
            this.producers.put((Object)info.getProducerId(), (Object)info);
        }
    }

    public Destination addDestination(ConnectionContext context, ActiveMQDestination destination) throws Throwable {
        Destination answer = this.next.addDestination(context, destination);
        ActiveMQTopic topic = AdvisorySupport.getDestinationAdvisoryTopic(destination);
        DestinationInfo info = new DestinationInfo(context.getConnectionId(), 0, destination);
        this.fireAdvisory(context, topic, info);
        this.destinations.put((Object)destination, (Object)info);
        return answer;
    }

    public void removeDestination(ConnectionContext context, ActiveMQDestination destination, long timeout) throws Throwable {
        this.next.removeDestination(context, destination, timeout);
        ActiveMQTopic topic = AdvisorySupport.getDestinationAdvisoryTopic(destination);
        DestinationInfo info = (DestinationInfo)this.destinations.remove((Object)destination);
        if (info != null) {
            info.setOperationType((byte)1);
            this.fireAdvisory(context, topic, info);
        }
    }

    public void removeConnection(ConnectionContext context, ConnectionInfo info, Throwable error) throws Throwable {
        this.next.removeConnection(context, info, error);
        ActiveMQTopic topic = AdvisorySupport.getConnectionAdvisoryTopic();
        this.fireAdvisory(context, topic, info.createRemoveCommand());
        this.connections.remove((Object)info.getConnectionId());
    }

    public void removeConsumer(ConnectionContext context, ConsumerInfo info) throws Throwable {
        this.next.removeConsumer(context, info);
        if (!AdvisorySupport.isAdvisoryTopic(info.getDestination())) {
            ActiveMQTopic topic = AdvisorySupport.getConsumerAdvisoryTopic(info.getDestination());
            this.fireAdvisory(context, topic, info.createRemoveCommand());
            this.consumers.remove((Object)info.getConsumerId());
        }
    }

    public void removeProducer(ConnectionContext context, ProducerInfo info) throws Throwable {
        this.next.removeProducer(context, info);
        if (info.getDestination() != null && !AdvisorySupport.isAdvisoryTopic(info.getDestination())) {
            ActiveMQTopic topic = AdvisorySupport.getProducerAdvisoryTopic(info.getDestination());
            this.fireAdvisory(context, topic, info.createRemoveCommand());
            this.producers.remove((Object)info.getProducerId());
        }
    }

    private void fireAdvisory(ConnectionContext context, ActiveMQTopic topic, Command command) throws Throwable {
        this.fireAdvisory(context, topic, command, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAdvisory(ConnectionContext context, ActiveMQTopic topic, Command command, ConsumerId targetConsumerId) throws Throwable {
        ActiveMQMessage advisoryMessage = new ActiveMQMessage();
        advisoryMessage.setDataStructure(command);
        advisoryMessage.setPersistent(false);
        advisoryMessage.setType("Advisory");
        advisoryMessage.setMessageId(new MessageId(this.advisoryProducerId, this.messageIdGenerator.getNextSequenceId()));
        advisoryMessage.setTargetConsumerId(targetConsumerId);
        advisoryMessage.setDestination(topic);
        advisoryMessage.setResponseRequired(false);
        advisoryMessage.setProducerId(this.advisoryProducerId);
        boolean originalFlowControl = context.isProducerFlowControl();
        try {
            context.setProducerFlowControl(false);
            this.next.send(context, advisoryMessage);
        }
        finally {
            context.setProducerFlowControl(originalFlowControl);
        }
    }
}

