/*
 * Decompiled with CFR 0.152.
 */
package org.activemq;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.XAConnection;
import org.activemq.ActiveMQConnectionConsumer;
import org.activemq.ActiveMQConnectionFactory;
import org.activemq.ActiveMQConnectionMetaData;
import org.activemq.ActiveMQDispatcher;
import org.activemq.ActiveMQInputStream;
import org.activemq.ActiveMQMessageTransformation;
import org.activemq.ActiveMQOutputStream;
import org.activemq.ActiveMQPrefetchPolicy;
import org.activemq.ActiveMQQueueSession;
import org.activemq.ActiveMQSession;
import org.activemq.ActiveMQTopicSession;
import org.activemq.AdvisoryConsumer;
import org.activemq.Closeable;
import org.activemq.ConnectionClosedException;
import org.activemq.StreamConnection;
import org.activemq.command.ActiveMQDestination;
import org.activemq.command.ActiveMQMessage;
import org.activemq.command.ActiveMQTempDestination;
import org.activemq.command.ActiveMQTempQueue;
import org.activemq.command.ActiveMQTempTopic;
import org.activemq.command.BrokerInfo;
import org.activemq.command.Command;
import org.activemq.command.ConnectionId;
import org.activemq.command.ConnectionInfo;
import org.activemq.command.ConsumerId;
import org.activemq.command.ConsumerInfo;
import org.activemq.command.ControlCommand;
import org.activemq.command.DestinationInfo;
import org.activemq.command.ExceptionResponse;
import org.activemq.command.Message;
import org.activemq.command.MessageDispatch;
import org.activemq.command.MessageId;
import org.activemq.command.ProducerId;
import org.activemq.command.RedeliveryPolicy;
import org.activemq.command.RemoveSubscriptionInfo;
import org.activemq.command.Response;
import org.activemq.command.SessionId;
import org.activemq.command.ShutdownInfo;
import org.activemq.management.JMSConnectionStatsImpl;
import org.activemq.management.JMSStatsImpl;
import org.activemq.management.StatsCapable;
import org.activemq.management.StatsImpl;
import org.activemq.thread.TaskRunnerFactory;
import org.activemq.transport.Transport;
import org.activemq.transport.TransportListener;
import org.activemq.util.IdGenerator;
import org.activemq.util.IntrospectionSupport;
import org.activemq.util.JMSExceptionSupport;
import org.activemq.util.LongSequenceGenerator;
import org.activemq.util.ServiceSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActiveMQConnection
implements Connection,
TopicConnection,
QueueConnection,
StatsCapable,
Closeable,
TransportListener,
StreamConnection {
    public static final TaskRunnerFactory SESSION_TASK_RUNNER = new TaskRunnerFactory("session Task", 7, true, 1000);
    private static final Log log = LogFactory.getLog((Class)ActiveMQConnection.class);
    private static final IdGenerator connectionIdGenerator = new IdGenerator();
    private static final IdGenerator clientIdGenerator = new IdGenerator();
    public static final String DEFAULT_USER = ActiveMQConnectionFactory.DEFAULT_USER;
    public static final String DEFAULT_PASSWORD = ActiveMQConnectionFactory.DEFAULT_PASSWORD;
    public static final String DEFAULT_BROKER_URL = "tcp://localhost:61616";
    private final ConnectionInfo info;
    private ExceptionListener exceptionListener;
    private String resourceManagerId;
    private boolean clientIDSet;
    private boolean isConnectionInfoSentToBroker;
    private boolean userSpecifiedClientID;
    private ActiveMQPrefetchPolicy prefetchPolicy = new ActiveMQPrefetchPolicy();
    private RedeliveryPolicy redeliveryPolicy;
    private boolean disableTimeStampsByDefault = false;
    private boolean onSendPrepareMessageBody = true;
    private boolean optimizedMessageDispatch = true;
    private boolean copyMessageOnSend = true;
    private boolean useCompression = false;
    private boolean objectMessageSerializationDefered = false;
    protected boolean asyncDispatch = true;
    private boolean useAsyncSend = false;
    private boolean useRetroactiveConsumer;
    private long flowControlSleepTime = 0L;
    private final JMSConnectionStatsImpl stats;
    private final JMSStatsImpl factoryStats;
    private final Transport transport;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean closing = new AtomicBoolean(false);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final CopyOnWriteArrayList sessions = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList connectionConsumers = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList inputStreams = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList outputStreams = new CopyOnWriteArrayList();
    private final ConcurrentHashMap dispatchers = new ConcurrentHashMap();
    private final LongSequenceGenerator sessionIdGenerator = new LongSequenceGenerator();
    private final SessionId connectionSessionId;
    private final LongSequenceGenerator consumerIdGenerator = new LongSequenceGenerator();
    private final LongSequenceGenerator producerIdGenerator = new LongSequenceGenerator();
    private final LongSequenceGenerator tempDestinationIdGenerator = new LongSequenceGenerator();
    private final LongSequenceGenerator localTransactionIdGenerator = new LongSequenceGenerator();
    final ConcurrentHashMap activeTempDestinations = new ConcurrentHashMap();
    private AdvisoryConsumer advisoryConsumer;
    private final CountDownLatch brokerInfoReceived = new CountDownLatch(1);

    protected ActiveMQConnection(Transport transport, String userName, String password, JMSStatsImpl factoryStats) throws Exception {
        this.transport = transport;
        this.info = new ConnectionInfo(new ConnectionId(connectionIdGenerator.generateId()));
        this.info.setUserName(userName);
        this.info.setPassword(password);
        this.connectionSessionId = new SessionId(this.info.getConnectionId(), -1L);
        this.factoryStats = factoryStats;
        this.factoryStats.addConnection(this);
        this.stats = new JMSConnectionStatsImpl((List)this.sessions, this instanceof XAConnection);
        this.transport.setTransportListener(this);
        transport.start();
    }

    public static ActiveMQConnection makeConnection() throws JMSException {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
        return (ActiveMQConnection)factory.createConnection();
    }

    public static ActiveMQConnection makeConnection(String uri) throws JMSException, URISyntaxException {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(uri);
        return (ActiveMQConnection)factory.createConnection();
    }

    public static ActiveMQConnection makeConnection(String user, String password, String uri) throws JMSException, URISyntaxException {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(user, password, new URI(uri));
        return (ActiveMQConnection)factory.createConnection();
    }

    public JMSConnectionStatsImpl getConnectionStats() {
        return this.stats;
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        this.ensureConnectionInfoSent();
        return new ActiveMQSession(this, this.getNextSessionId(), transacted ? 0 : (acknowledgeMode == 0 ? 1 : acknowledgeMode), this.asyncDispatch);
    }

    protected SessionId getNextSessionId() {
        return new SessionId(this.info.getConnectionId(), this.sessionIdGenerator.getNextSequenceId());
    }

    public String getClientID() throws JMSException {
        this.checkClosed();
        return this.info.getClientId();
    }

    public void setClientID(String newClientID) throws JMSException {
        this.checkClosed();
        if (this.clientIDSet) {
            throw new IllegalStateException("The clientID has already been set");
        }
        if (this.isConnectionInfoSentToBroker) {
            throw new IllegalStateException("Setting clientID on a used Connection is not allowed");
        }
        this.info.setClientId(newClientID);
        this.userSpecifiedClientID = true;
        this.ensureConnectionInfoSent();
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        this.checkClosed();
        return ActiveMQConnectionMetaData.INSTANCE;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        this.checkClosed();
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.checkClosed();
        this.exceptionListener = listener;
    }

    public void start() throws JMSException {
        this.checkClosed();
        this.ensureConnectionInfoSent();
        if (this.started.compareAndSet(false, true)) {
            Iterator i = this.sessions.iterator();
            while (i.hasNext()) {
                ActiveMQSession session = (ActiveMQSession)i.next();
                session.start();
            }
        }
    }

    protected boolean isStarted() {
        return this.started.get();
    }

    public void stop() throws JMSException {
        this.checkClosed();
        if (this.started.compareAndSet(true, false)) {
            Iterator i = this.sessions.iterator();
            while (i.hasNext()) {
                ActiveMQSession s = (ActiveMQSession)i.next();
                s.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        this.checkClosed();
        this.stop();
        ActiveMQConnection activeMQConnection = this;
        synchronized (activeMQConnection) {
            if (!this.closed.get()) {
                Object c;
                this.closing.set(true);
                if (this.advisoryConsumer != null) {
                    this.advisoryConsumer.dispose();
                    this.advisoryConsumer = null;
                }
                Iterator i = this.sessions.iterator();
                while (i.hasNext()) {
                    ActiveMQSession s = (ActiveMQSession)i.next();
                    s.dispose();
                }
                i = this.connectionConsumers.iterator();
                while (i.hasNext()) {
                    c = (ActiveMQConnectionConsumer)i.next();
                    ((ActiveMQConnectionConsumer)c).dispose();
                }
                i = this.inputStreams.iterator();
                while (i.hasNext()) {
                    c = (ActiveMQInputStream)i.next();
                    ((ActiveMQInputStream)c).dispose();
                }
                i = this.outputStreams.iterator();
                while (i.hasNext()) {
                    c = (ActiveMQOutputStream)i.next();
                    ((ActiveMQOutputStream)c).dispose();
                }
                if (this.isConnectionInfoSentToBroker) {
                    this.syncSendPacket(this.info.createRemoveCommand());
                }
                this.asyncSendPacket(new ShutdownInfo());
                ServiceSupport.dispose(this.transport);
                this.started.set(false);
                this.closed.set(true);
                this.closing.set(false);
            }
        }
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.createDurableConnectionConsumer(topic, subscriptionName, messageSelector, sessionPool, maxMessages, false);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages, boolean noLocal) throws JMSException {
        this.checkClosed();
        this.ensureConnectionInfoSent();
        SessionId sessionId = new SessionId(this.info.getConnectionId(), -1L);
        ConsumerInfo info = new ConsumerInfo(new ConsumerId(sessionId, this.consumerIdGenerator.getNextSequenceId()));
        info.setDestination(ActiveMQMessageTransformation.transformDestination((Destination)topic));
        info.setSubcriptionName(subscriptionName);
        info.setSelector(messageSelector);
        info.setPrefetchSize(maxMessages);
        if (info.getDestination().getOptions() != null) {
            HashMap options = new HashMap(info.getDestination().getOptions());
            IntrospectionSupport.setProperties(this.info, options, "consumer.");
        }
        return new ActiveMQConnectionConsumer(this, sessionPool, info);
    }

    public ActiveMQPrefetchPolicy getPrefetchPolicy() {
        return this.prefetchPolicy;
    }

    public void setPrefetchPolicy(ActiveMQPrefetchPolicy prefetchPolicy) {
        this.prefetchPolicy = prefetchPolicy;
    }

    public Transport getTransportChannel() {
        return this.transport;
    }

    public String getInitializedClientID() throws JMSException {
        this.ensureConnectionInfoSent();
        return this.info.getClientId();
    }

    public boolean isDisableTimeStampsByDefault() {
        return this.disableTimeStampsByDefault;
    }

    public void setDisableTimeStampsByDefault(boolean timeStampsDisableByDefault) {
        this.disableTimeStampsByDefault = timeStampsDisableByDefault;
    }

    public boolean isOptimizedMessageDispatch() {
        return this.optimizedMessageDispatch;
    }

    public void setOptimizedMessageDispatch(boolean dispatchOptimizedMessage) {
        this.optimizedMessageDispatch = dispatchOptimizedMessage;
    }

    public boolean isOnSendPrepareMessageBody() {
        return this.onSendPrepareMessageBody;
    }

    public void setOnSendPrepareMessageBody(boolean onSendPrepareMessageBody) {
        this.onSendPrepareMessageBody = onSendPrepareMessageBody;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.info;
    }

    public boolean isUseRetroactiveConsumer() {
        return this.useRetroactiveConsumer;
    }

    public void setUseRetroactiveConsumer(boolean useRetroactiveConsumer) {
        this.useRetroactiveConsumer = useRetroactiveConsumer;
    }

    protected void addSession(ActiveMQSession session) throws JMSException {
        this.sessions.add((Object)session);
        if (this.sessions.size() > 1 || session.isTransacted()) {
            this.optimizedMessageDispatch = false;
        }
    }

    protected void removeSession(ActiveMQSession session) {
        this.sessions.remove((Object)session);
    }

    protected void addConnectionConsumer(ActiveMQConnectionConsumer connectionConsumer) throws JMSException {
        this.connectionConsumers.add((Object)connectionConsumer);
    }

    protected void removeConnectionConsumer(ActiveMQConnectionConsumer connectionConsumer) {
        this.connectionConsumers.remove((Object)connectionConsumer);
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return new ActiveMQTopicSession((ActiveMQSession)this.createSession(transacted, acknowledgeMode));
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.createConnectionConsumer((Destination)topic, messageSelector, sessionPool, maxMessages, false);
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.createConnectionConsumer((Destination)queue, messageSelector, sessionPool, maxMessages, false);
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.createConnectionConsumer(destination, messageSelector, sessionPool, maxMessages, false);
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages, boolean noLocal) throws JMSException {
        this.checkClosed();
        this.ensureConnectionInfoSent();
        ConsumerId consumerId = this.createConsumerId();
        ConsumerInfo info = new ConsumerInfo(consumerId);
        info.setDestination(ActiveMQMessageTransformation.transformDestination(destination));
        info.setSelector(messageSelector);
        info.setPrefetchSize(maxMessages);
        info.setNoLocal(noLocal);
        if (info.getDestination().getOptions() != null) {
            HashMap options = new HashMap(info.getDestination().getOptions());
            IntrospectionSupport.setProperties(this.info, options, "consumer.");
        }
        return new ActiveMQConnectionConsumer(this, sessionPool, info);
    }

    private ConsumerId createConsumerId() {
        return new ConsumerId(this.connectionSessionId, this.consumerIdGenerator.getNextSequenceId());
    }

    private ProducerId createProducerId() {
        return new ProducerId(this.connectionSessionId, this.producerIdGenerator.getNextSequenceId());
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return new ActiveMQQueueSession((ActiveMQSession)this.createSession(transacted, acknowledgeMode));
    }

    public void checkClientIDWasManuallySpecified() throws JMSException {
        if (!this.userSpecifiedClientID) {
            throw new JMSException("You cannot create a durable subscriber without specifying a unique clientID on a Connection");
        }
    }

    public void asyncSendPacket(Command command) throws JMSException {
        if (this.isClosed()) {
            throw new ConnectionClosedException();
        }
        if (command.isMessage() && this.flowControlSleepTime > 0L) {
            try {
                Thread.sleep(this.flowControlSleepTime);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        try {
            this.transport.oneway(command);
        }
        catch (IOException e) {
            throw JMSExceptionSupport.create(e);
        }
    }

    public Response syncSendPacket(Command command) throws JMSException {
        if (this.isClosed()) {
            throw new ConnectionClosedException();
        }
        if (command.isMessage() && this.flowControlSleepTime > 0L) {
            try {
                Thread.sleep(this.flowControlSleepTime);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        try {
            Response response = this.transport.request(command);
            if (response.isException()) {
                ExceptionResponse er = (ExceptionResponse)response;
                if (er.getException() instanceof JMSException) {
                    throw (JMSException)er.getException();
                }
                throw JMSExceptionSupport.create(er.getException());
            }
            return response;
        }
        catch (IOException e) {
            throw JMSExceptionSupport.create(e);
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public StatsImpl getStats() {
        return this.stats;
    }

    protected synchronized void checkClosed() throws JMSException {
        if (this.closed.get()) {
            throw new ConnectionClosedException();
        }
    }

    protected void ensureConnectionInfoSent() throws JMSException {
        if (this.isConnectionInfoSentToBroker) {
            return;
        }
        if (this.info.getClientId() == null || this.info.getClientId().trim().length() == 0) {
            this.info.setClientId(clientIdGenerator.generateId());
        }
        this.syncSendPacket(this.info);
        this.isConnectionInfoSentToBroker = true;
        ConsumerId consumerId = new ConsumerId(new SessionId(this.info.getConnectionId(), -1L), this.consumerIdGenerator.getNextSequenceId());
        this.advisoryConsumer = new AdvisoryConsumer(this, consumerId);
    }

    public boolean isUseAsyncSend() {
        return this.useAsyncSend;
    }

    public void setUseAsyncSend(boolean useAsyncSend) {
        this.useAsyncSend = useAsyncSend;
    }

    public void cleanup() throws JMSException {
        Object c;
        if (this.advisoryConsumer != null) {
            this.advisoryConsumer.dispose();
            this.advisoryConsumer = null;
        }
        Iterator i = this.sessions.iterator();
        while (i.hasNext()) {
            ActiveMQSession s = (ActiveMQSession)i.next();
            s.dispose();
        }
        i = this.connectionConsumers.iterator();
        while (i.hasNext()) {
            c = (ActiveMQConnectionConsumer)i.next();
            ((ActiveMQConnectionConsumer)c).dispose();
        }
        i = this.inputStreams.iterator();
        while (i.hasNext()) {
            c = (ActiveMQInputStream)i.next();
            ((ActiveMQInputStream)c).dispose();
        }
        i = this.outputStreams.iterator();
        while (i.hasNext()) {
            c = (ActiveMQOutputStream)i.next();
            ((ActiveMQOutputStream)c).dispose();
        }
        if (this.isConnectionInfoSentToBroker) {
            this.asyncSendPacket(this.info.createRemoveCommand());
            this.isConnectionInfoSentToBroker = false;
        }
        if (this.userSpecifiedClientID) {
            this.info.setClientId(null);
            this.userSpecifiedClientID = false;
        }
        this.clientIDSet = false;
        this.started.set(false);
    }

    public void changeUserInfo(String userName, String password) throws JMSException {
        if (this.isConnectionInfoSentToBroker) {
            throw new IllegalStateException("changeUserInfo used Connection is not allowed");
        }
        this.info.setUserName(userName);
        this.info.setPassword(password);
    }

    public String getResourceManagerId() throws JMSException {
        this.waitForBrokerInfo();
        if (this.resourceManagerId == null) {
            throw new JMSException("Resource manager id could not be determined.");
        }
        return this.resourceManagerId;
    }

    public RedeliveryPolicy getRedeliveryPolicy() throws JMSException {
        this.waitForBrokerInfo();
        return this.redeliveryPolicy;
    }

    private void waitForBrokerInfo() throws JMSException {
        try {
            this.brokerInfoReceived.await();
        }
        catch (InterruptedException e) {
            throw JMSExceptionSupport.create(e);
        }
    }

    Transport getTransport() {
        return this.transport;
    }

    public void addDispatcher(ConsumerId consumerId, ActiveMQDispatcher dispatcher) {
        this.dispatchers.put((Object)consumerId, (Object)dispatcher);
    }

    public void removeDispatcher(ConsumerId consumerId) {
        this.dispatchers.remove((Object)consumerId);
    }

    public void onCommand(Command command) {
        if (!this.closed.get() && command != null) {
            if (command.isMessageDispatch()) {
                MessageDispatch md = (MessageDispatch)command;
                ActiveMQDispatcher dispatcher = (ActiveMQDispatcher)this.dispatchers.get((Object)md.getConsumerId());
                if (dispatcher != null) {
                    Message msg = md.getMessage();
                    if (msg != null) {
                        msg = msg.copy();
                        msg.setReadOnlyBody(true);
                        msg.setReadOnlyProperties(true);
                        msg.setRedeliveryCounter(md.getRedeliveryCounter());
                        msg.setConnection(this);
                        md.setMessage(msg);
                    }
                    dispatcher.dispatch(md);
                }
            } else if (command.isBrokerInfo()) {
                BrokerInfo brokerInfo = (BrokerInfo)command;
                this.resourceManagerId = brokerInfo.getBrokerId().getBrokerId();
                if (this.redeliveryPolicy == null) {
                    this.redeliveryPolicy = brokerInfo.getRedeliveryPolicy() != null ? brokerInfo.getRedeliveryPolicy() : new RedeliveryPolicy();
                }
                this.brokerInfoReceived.countDown();
            } else if (command instanceof ControlCommand) {
                this.onControlCommand((ControlCommand)command);
            }
        }
    }

    public void onAsyncException(Throwable error) {
        if (!this.closed.get() && !this.closing.get()) {
            if (this.exceptionListener != null) {
                if (!(error instanceof JMSException)) {
                    error = JMSExceptionSupport.create(error);
                }
                this.exceptionListener.onException((JMSException)error);
            } else {
                log.warn((Object)("Async exception with no exception listener: " + error), error);
            }
        }
    }

    public void onException(IOException error) {
        this.onAsyncException(error);
        ServiceSupport.dispose(this.transport);
        this.brokerInfoReceived.countDown();
    }

    protected ActiveMQTempDestination createTempDestination(boolean topic) throws JMSException {
        ActiveMQTempDestination dest = topic ? new ActiveMQTempTopic(this.info.getConnectionId(), this.tempDestinationIdGenerator.getNextSequenceId()) : new ActiveMQTempQueue(this.info.getConnectionId(), this.tempDestinationIdGenerator.getNextSequenceId());
        DestinationInfo info = new DestinationInfo();
        info.setConnectionId(this.info.getConnectionId());
        info.setOperationType((byte)0);
        info.setDestination(dest);
        this.syncSendPacket(info);
        dest.setConnection(this);
        this.activeTempDestinations.put((Object)dest, (Object)dest);
        return dest;
    }

    public void deleteTempDestination(ActiveMQTempDestination destination) throws JMSException {
        this.checkClosed();
        this.activeTempDestinations.remove((Object)destination);
        DestinationInfo info = new DestinationInfo();
        info.setConnectionId(this.info.getConnectionId());
        info.setOperationType((byte)1);
        info.setDestination(destination);
        info.setTimeout(5000L);
        this.syncSendPacket(info);
    }

    public boolean isDeleted(ActiveMQDestination dest) {
        return !this.activeTempDestinations.contains((Object)dest);
    }

    public boolean isCopyMessageOnSend() {
        return this.copyMessageOnSend;
    }

    public LongSequenceGenerator getLocalTransactionIdGenerator() {
        return this.localTransactionIdGenerator;
    }

    public boolean isUseCompression() {
        return this.useCompression;
    }

    public void setUseCompression(boolean useCompression) {
        this.useCompression = useCompression;
    }

    public void destroyDestination(ActiveMQDestination destination) throws JMSException {
        this.checkClosed();
        this.ensureConnectionInfoSent();
        DestinationInfo info = new DestinationInfo();
        info.setConnectionId(this.info.getConnectionId());
        info.setOperationType((byte)1);
        info.setDestination(destination);
        info.setTimeout(5000L);
        this.syncSendPacket(info);
    }

    public boolean isAsyncDispatch() {
        return this.asyncDispatch;
    }

    public void setAsyncDispatch(boolean asyncDispatch) {
        this.asyncDispatch = asyncDispatch;
    }

    public boolean isObjectMessageSerializationDefered() {
        return this.objectMessageSerializationDefered;
    }

    public void setObjectMessageSerializationDefered(boolean objectMessageSerializationDefered) {
        this.objectMessageSerializationDefered = objectMessageSerializationDefered;
    }

    public InputStream createInputStream(Destination dest) throws JMSException {
        return this.createInputStream(dest, null);
    }

    public InputStream createInputStream(Destination dest, String messageSelector) throws JMSException {
        return this.createInputStream(dest, messageSelector, false);
    }

    public InputStream createInputStream(Destination dest, String messageSelector, boolean noLocal) throws JMSException {
        return this.doCreateInputStream(dest, messageSelector, noLocal, null);
    }

    public InputStream createDurableInputStream(Topic dest, String name) throws JMSException {
        return this.createInputStream((Destination)dest, null, false);
    }

    public InputStream createDurableInputStream(Topic dest, String name, String messageSelector) throws JMSException {
        return this.createDurableInputStream(dest, name, messageSelector, false);
    }

    public InputStream createDurableInputStream(Topic dest, String name, String messageSelector, boolean noLocal) throws JMSException {
        return this.doCreateInputStream((Destination)dest, messageSelector, noLocal, name);
    }

    private InputStream doCreateInputStream(Destination dest, String messageSelector, boolean noLocal, String subName) throws JMSException {
        this.checkClosed();
        this.ensureConnectionInfoSent();
        return new ActiveMQInputStream(this, this.createConsumerId(), ActiveMQDestination.transform(dest), messageSelector, noLocal, subName, this.prefetchPolicy.getInputStreamPrefetch());
    }

    public OutputStream createOutputStream(Destination dest) throws JMSException {
        return this.createOutputStream(dest, null, 2, 4, 0L);
    }

    public OutputStream createOutputStream(Destination dest, Map streamProperties, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkClosed();
        this.ensureConnectionInfoSent();
        return new ActiveMQOutputStream(this, this.createProducerId(), ActiveMQDestination.transform(dest), streamProperties, deliveryMode, priority, timeToLive);
    }

    public void unsubscribe(String name) throws JMSException {
        this.checkClosed();
        RemoveSubscriptionInfo rsi = new RemoveSubscriptionInfo();
        rsi.setConnectionId(this.getConnectionInfo().getConnectionId());
        rsi.setSubcriptionName(name);
        rsi.setClientId(this.getConnectionInfo().getClientId());
        this.syncSendPacket(rsi);
    }

    void send(ActiveMQDestination destination, ActiveMQMessage msg, MessageId messageId, int deliveryMode, int priority, long timeToLive, boolean async) throws JMSException {
        this.checkClosed();
        if (destination.isTemporary() && this.isDeleted(destination)) {
            throw new JMSException("Cannot publish to a deleted Destination: " + destination);
        }
        msg.setJMSDestination(destination);
        msg.setJMSDeliveryMode(deliveryMode);
        long expiration = 0L;
        if (!this.isDisableTimeStampsByDefault()) {
            long timeStamp = System.currentTimeMillis();
            msg.setJMSTimestamp(timeStamp);
            if (timeToLive > 0L) {
                expiration = timeToLive + timeStamp;
            }
        }
        msg.setJMSExpiration(expiration);
        msg.setJMSPriority(priority);
        msg.setJMSRedelivered(false);
        msg.setMessageId(messageId);
        msg.onSend();
        msg.setProducerId(msg.getMessageId().getProducerId());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending message: " + msg));
        }
        if (async) {
            this.asyncSendPacket(msg);
        } else {
            this.syncSendPacket(msg);
        }
    }

    public void addOutputStream(ActiveMQOutputStream stream) {
        this.outputStreams.add((Object)stream);
    }

    public void removeOutputStream(ActiveMQOutputStream stream) {
        this.outputStreams.remove((Object)stream);
    }

    public void addInputStream(ActiveMQInputStream stream) {
        this.inputStreams.add((Object)stream);
    }

    public void removeInputStream(ActiveMQInputStream stream) {
        this.inputStreams.remove((Object)stream);
    }

    protected void onControlCommand(ControlCommand command) {
        String text = command.getCommand();
        if (text != null && text.equals("shutdown")) {
            log.info((Object)"JVM told to shutdown");
            System.exit(0);
        }
    }

    public void setCopyMessageOnSend(boolean copyMessageOnSend) {
        this.copyMessageOnSend = copyMessageOnSend;
    }
}

