/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class URISupport {
    public static Map parseQuery(String uri) throws URISyntaxException {
        try {
            HashMap<String, String> rc = new HashMap<String, String>();
            String[] parameters = uri.split("&");
            for (int i = 0; i < parameters.length; ++i) {
                int p = parameters[i].indexOf("=");
                if (p >= 0) {
                    String name = URLDecoder.decode(parameters[i].substring(0, p), "UTF-8");
                    String value = URLDecoder.decode(parameters[i].substring(p + 1), "UTF-8");
                    rc.put(name, value);
                    continue;
                }
                rc.put(parameters[i], null);
            }
            return rc;
        }
        catch (UnsupportedEncodingException e) {
            throw (URISyntaxException)new URISyntaxException(e.toString(), "Invalid encoding").initCause(e);
        }
    }

    public static Map parseParamters(URI uri) throws URISyntaxException {
        return uri.getQuery() == null ? Collections.EMPTY_MAP : URISupport.parseQuery(URISupport.stripPrefix(uri.getQuery(), "?"));
    }

    public static URI removeQuery(URI uri) throws URISyntaxException {
        return URISupport.createURIWithQuery(uri, null);
    }

    public static URI createURIWithQuery(URI uri, String query) throws URISyntaxException {
        return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), query, uri.getFragment());
    }

    public static CompositeData parseComposite(URI uri) throws URISyntaxException {
        CompositeData rc = new CompositeData();
        rc.scheme = uri.getScheme();
        String ssp = URISupport.stripPrefix(uri.getSchemeSpecificPart().trim(), "//").trim();
        int p = ssp.indexOf("://");
        if (p >= 0) {
            String params;
            String componentString;
            int intialParen = ssp.substring(0, p).indexOf("(");
            if (intialParen == 0) {
                p = ssp.indexOf(")");
                if (p < 0) {
                    throw new URISyntaxException(uri.toString(), "Expected ')' to close initial '('");
                }
                rc.host = ssp.substring(0, intialParen);
                p = rc.host.indexOf("/");
                if (p >= 0) {
                    rc.path = rc.host.substring(p);
                    rc.host = rc.host.substring(0, p);
                }
                p = ssp.indexOf(")");
                componentString = ssp.substring(intialParen + 1, p);
                params = ssp.substring(p + 1).trim();
            } else if ((p = ssp.lastIndexOf("/", p)) >= 0) {
                componentString = ssp.substring(p + 1);
                rc.host = ssp.substring(0, p);
                p = rc.host.indexOf("/");
                if (p >= 0) {
                    rc.path = rc.host.substring(p);
                    rc.host = rc.host.substring(0, p);
                }
                params = "";
            } else {
                componentString = ssp;
                params = "";
            }
            String[] components = componentString.split(",");
            rc.components = new URI[components.length];
            for (int i = 0; i < components.length; ++i) {
                rc.components[i] = new URI(components[i].trim());
            }
            rc.parameters = params.indexOf("?") == 0 ? URISupport.parseQuery(params.substring(1)) : Collections.EMPTY_MAP;
        } else {
            rc.host = uri.getHost();
            rc.path = uri.getPath();
            rc.components = new URI[0];
            rc.parameters = uri.getQuery() != null ? URISupport.parseQuery(uri.getQuery()) : Collections.EMPTY_MAP;
            rc.fragment = uri.getFragment();
        }
        rc.fragment = uri.getFragment();
        return rc;
    }

    private static String stripPrefix(String value, String prefix) {
        if (value.startsWith(prefix)) {
            return value.substring(prefix.length());
        }
        return value;
    }

    public static URI stripScheme(URI uri) throws URISyntaxException {
        return new URI(URISupport.stripPrefix(uri.getSchemeSpecificPart().trim(), "//"));
    }

    public static String createQueryString(Map options) throws URISyntaxException {
        try {
            if (options.size() > 0) {
                StringBuffer rc = new StringBuffer();
                boolean first = true;
                Iterator iter = options.keySet().iterator();
                while (iter.hasNext()) {
                    if (first) {
                        first = false;
                    } else {
                        rc.append("&");
                    }
                    String key = (String)iter.next();
                    String value = (String)options.get(key);
                    rc.append(URLEncoder.encode(key, "UTF-8"));
                    rc.append("=");
                    rc.append(URLEncoder.encode(value, "UTF-8"));
                }
                return rc.toString();
            }
            return "";
        }
        catch (UnsupportedEncodingException e) {
            throw (URISyntaxException)new URISyntaxException(e.toString(), "Invalid encoding").initCause(e);
        }
    }

    public static URI createRemainingURI(URI originalURI, Map params) throws URISyntaxException {
        return URISupport.createURIWithQuery(originalURI, URISupport.createQueryString(params));
    }

    public static URI changeScheme(URI bindAddr, String scheme) throws URISyntaxException {
        return new URI(scheme, bindAddr.getUserInfo(), bindAddr.getHost(), bindAddr.getPort(), bindAddr.getPath(), bindAddr.getQuery(), bindAddr.getFragment());
    }

    public static class CompositeData {
        String scheme;
        String path;
        URI[] components;
        Map parameters;
        String fragment;
        public String host;

        public URI[] getComponents() {
            return this.components;
        }

        public String getFragment() {
            return this.fragment;
        }

        public Map getParameters() {
            return this.parameters;
        }

        public String getScheme() {
            return this.scheme;
        }

        public String getPath() {
            return this.path;
        }

        public String getHost() {
            return this.host;
        }
    }
}

